/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.app.http.source;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.stream.annotation.EnableBinding;
import org.springframework.cloud.stream.app.http.source.HttpSourceProperties;
import org.springframework.cloud.stream.messaging.Source;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.expression.Expression;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.integration.expression.ValueExpression;
import org.springframework.integration.http.dsl.Http;
import org.springframework.integration.http.dsl.HttpRequestHandlerEndpointSpec;
import org.springframework.integration.http.inbound.HttpRequestHandlingEndpointSupport;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;

@EnableBinding(value={Source.class})
@EnableConfigurationProperties(value={HttpSourceProperties.class})
public class HttpSourceConfiguration {
    @Autowired
    private Source channels;
    @Autowired
    private HttpSourceProperties properties;

    @Bean
    public HttpRequestHandlingEndpointSupport httpSourceString() {
        return (HttpRequestHandlingEndpointSupport)((HttpRequestHandlerEndpointSpec)this.buildHttpRequestHandlerEndpointSpec("text/*", "application/json").requestPayloadType(String.class)).get();
    }

    @Bean
    public HttpRequestHandlingEndpointSupport httpSourceBytes() {
        return (HttpRequestHandlingEndpointSupport)this.buildHttpRequestHandlerEndpointSpec("*/*").get();
    }

    private HttpRequestHandlerEndpointSpec buildHttpRequestHandlerEndpointSpec(String ... consumes) {
        return (HttpRequestHandlerEndpointSpec)((HttpRequestHandlerEndpointSpec)((HttpRequestHandlerEndpointSpec)((HttpRequestHandlerEndpointSpec)((HttpRequestHandlerEndpointSpec)Http.inboundChannelAdapter((String[])new String[]{this.properties.getPathPattern()}).mappedRequestHeaders(this.properties.getMappedRequestHeaders())).statusCodeExpression((Expression)new ValueExpression((Object)HttpStatus.ACCEPTED))).requestMapping(requestMapping -> requestMapping.methods(new HttpMethod[]{HttpMethod.POST}).consumes(consumes))).crossOrigin(crossOrigin -> crossOrigin.origin(this.properties.getCors().getAllowedOrigins()).allowedHeaders(this.properties.getCors().getAllowedHeaders()).allowCredentials(this.properties.getCors().getAllowCredentials()))).requestChannel(this.channels.output());
    }

    @Configuration
    protected static class HttpSourceSecurityConfiguration
    extends WebSecurityConfigurerAdapter {
        @Autowired
        private HttpSourceProperties properties;

        protected HttpSourceSecurityConfiguration() {
        }

        protected void configure(HttpSecurity http) throws Exception {
            if (!this.properties.isEnableSecurity()) {
                http.requestMatcher(request -> false);
            } else if (!this.properties.isEnableCsrf()) {
                super.configure(http);
                http.csrf().disable();
            } else {
                super.configure(http);
            }
        }
    }
}

