/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.app.http.source;

import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.stream.annotation.EnableBinding;
import org.springframework.cloud.stream.app.http.source.DefaultMixedCaseContentTypeHttpHeaderMapper;
import org.springframework.cloud.stream.app.http.source.HttpSourceProperties;
import org.springframework.cloud.stream.messaging.Source;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.expression.Expression;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.integration.dsl.http.BaseHttpInboundEndpointSpec;
import org.springframework.integration.dsl.http.Http;
import org.springframework.integration.dsl.http.HttpRequestHandlerEndpointSpec;
import org.springframework.integration.dsl.support.Consumer;
import org.springframework.integration.expression.ValueExpression;
import org.springframework.integration.http.inbound.HttpRequestHandlingEndpointSupport;
import org.springframework.integration.mapping.HeaderMapper;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.web.util.matcher.RequestMatcher;

@EnableBinding(value={Source.class})
@EnableConfigurationProperties(value={HttpSourceProperties.class})
public class HttpSourceConfiguration {
    @Autowired
    private Source channels;
    @Autowired
    private HttpSourceProperties properties;

    @Bean
    public HttpRequestHandlingEndpointSupport httpSourceString() {
        return (HttpRequestHandlingEndpointSupport)((HttpRequestHandlerEndpointSpec)this.buildHttpRequestHandlerEndpointSpec("text/*", "application/json").requestPayloadType(String.class)).get();
    }

    @Bean
    public HttpRequestHandlingEndpointSupport httpSourceBytes() {
        return (HttpRequestHandlingEndpointSupport)this.buildHttpRequestHandlerEndpointSpec("*/*").get();
    }

    private HttpRequestHandlerEndpointSpec buildHttpRequestHandlerEndpointSpec(final String ... consumes) {
        DefaultMixedCaseContentTypeHttpHeaderMapper defaultHttpHeaderMapper = DefaultMixedCaseContentTypeHttpHeaderMapper.inboundMapper();
        defaultHttpHeaderMapper.setInboundHeaderNames(this.properties.getMappedRequestHeaders());
        return (HttpRequestHandlerEndpointSpec)((HttpRequestHandlerEndpointSpec)((HttpRequestHandlerEndpointSpec)((HttpRequestHandlerEndpointSpec)Http.inboundChannelAdapter((String[])new String[]{this.properties.getPathPattern()}).headerMapper((HeaderMapper)defaultHttpHeaderMapper)).statusCodeExpression((Expression)new ValueExpression((Object)HttpStatus.ACCEPTED))).requestMapping((Consumer)new Consumer<BaseHttpInboundEndpointSpec.RequestMappingSpec>(){

            public void accept(BaseHttpInboundEndpointSpec.RequestMappingSpec requestMappingSpec) {
                requestMappingSpec.methods(new HttpMethod[]{HttpMethod.POST}).consumes(consumes);
            }
        })).requestChannel(this.channels.output());
    }

    @Configuration
    @ConditionalOnProperty(prefix="security.basic", name={"enabled"}, havingValue="false", matchIfMissing=true)
    @EnableWebSecurity
    protected static class DisableSecurityConfiguration
    extends WebSecurityConfigurerAdapter {
        protected DisableSecurityConfiguration() {
        }

        protected void configure(HttpSecurity http) throws Exception {
            http.requestMatcher(new RequestMatcher(){

                public boolean matches(HttpServletRequest request) {
                    return false;
                }
            });
        }
    }
}

