/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.app.gemfire.cq.source;

import com.gemstone.gemfire.cache.RegionService;
import com.gemstone.gemfire.pdx.PdxInstance;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.stream.annotation.EnableBinding;
import org.springframework.cloud.stream.app.gemfire.JsonObjectTransformer;
import org.springframework.cloud.stream.app.gemfire.config.GemfireClientCacheConfiguration;
import org.springframework.cloud.stream.app.gemfire.config.GemfirePoolConfiguration;
import org.springframework.cloud.stream.app.gemfire.cq.source.GemfireCqSourceProperties;
import org.springframework.cloud.stream.messaging.Source;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.PropertySource;
import org.springframework.data.gemfire.client.ClientCacheFactoryBean;
import org.springframework.data.gemfire.listener.ContinuousQueryListener;
import org.springframework.data.gemfire.listener.ContinuousQueryListenerContainer;
import org.springframework.integration.channel.DirectChannel;
import org.springframework.integration.dsl.IntegrationFlow;
import org.springframework.integration.dsl.IntegrationFlowBuilder;
import org.springframework.integration.dsl.IntegrationFlows;
import org.springframework.integration.gemfire.inbound.ContinuousQueryMessageProducer;
import org.springframework.integration.router.AbstractMessageRouter;
import org.springframework.integration.router.PayloadTypeRouter;
import org.springframework.messaging.MessageChannel;

@EnableBinding(value={Source.class})
@Import(value={GemfireClientCacheConfiguration.class, GemfirePoolConfiguration.class})
@EnableConfigurationProperties(value={GemfireCqSourceProperties.class})
@PropertySource(value={"classpath:gemfire-cq-source.properties"})
public class GemfireCqSourceConfiguration {
    @Autowired
    private GemfireCqSourceProperties config;
    @Autowired
    @Qualifier(value="output")
    private MessageChannel output;
    @Autowired
    private ClientCacheFactoryBean clientCache;

    @Bean
    public MessageChannel convertToStringChannel() {
        return new DirectChannel();
    }

    @Bean
    public MessageChannel routerChannel() {
        return new DirectChannel();
    }

    @Bean
    PayloadTypeRouter payloadTypeRouter() {
        PayloadTypeRouter router = new PayloadTypeRouter();
        router.setDefaultOutputChannel(this.output);
        router.setChannelMapping(PdxInstance.class.getName(), "convertToStringChannel");
        return router;
    }

    @Bean
    public IntegrationFlow startFlow() {
        return ((IntegrationFlowBuilder)IntegrationFlows.from((MessageChannel)this.routerChannel()).route((AbstractMessageRouter)this.payloadTypeRouter())).get();
    }

    @Bean
    JsonObjectTransformer transformer() {
        return new JsonObjectTransformer();
    }

    @Bean
    IntegrationFlow convertToString() {
        return ((IntegrationFlowBuilder)((IntegrationFlowBuilder)IntegrationFlows.from((MessageChannel)this.convertToStringChannel()).transform((Object)this.transformer(), "toString")).channel(this.output)).get();
    }

    @Bean
    ContinuousQueryListener continuousQueryListener() {
        ContinuousQueryMessageProducer continuousQueryMessageProducer = new ContinuousQueryMessageProducer(this.continuousQueryListenerContainer(), this.config.getQuery());
        continuousQueryMessageProducer.setExpressionPayload(this.config.getCqEventExpression());
        continuousQueryMessageProducer.setOutputChannel(this.routerChannel());
        return continuousQueryMessageProducer;
    }

    @Bean
    ContinuousQueryListenerContainer continuousQueryListenerContainer() {
        ContinuousQueryListenerContainer continuousQueryListenerContainer = new ContinuousQueryListenerContainer();
        try {
            continuousQueryListenerContainer.setCache((RegionService)this.clientCache.getObject());
        }
        catch (Exception e) {
            throw new BeanCreationException(e.getLocalizedMessage(), (Throwable)e);
        }
        return continuousQueryListenerContainer;
    }
}

