/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.app.file.source;

import java.io.File;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.stream.annotation.EnableBinding;
import org.springframework.cloud.stream.app.file.FileConsumerProperties;
import org.springframework.cloud.stream.app.file.FileReadingMode;
import org.springframework.cloud.stream.app.file.FileUtils;
import org.springframework.cloud.stream.app.file.source.FileSourceProperties;
import org.springframework.cloud.stream.app.trigger.TriggerConfiguration;
import org.springframework.cloud.stream.app.trigger.TriggerPropertiesMaxMessagesDefaultUnlimited;
import org.springframework.cloud.stream.messaging.Source;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.integration.dsl.IntegrationFlow;
import org.springframework.integration.dsl.IntegrationFlowBuilder;
import org.springframework.integration.dsl.IntegrationFlows;
import org.springframework.integration.dsl.MessageSourceSpec;
import org.springframework.integration.file.dsl.FileInboundChannelAdapterSpec;
import org.springframework.integration.file.dsl.Files;
import org.springframework.util.StringUtils;

@EnableBinding(value={Source.class})
@Import(value={TriggerConfiguration.class})
@EnableConfigurationProperties(value={FileSourceProperties.class, FileConsumerProperties.class, TriggerPropertiesMaxMessagesDefaultUnlimited.class})
public class FileSourceConfiguration {
    @Autowired
    private FileSourceProperties properties;
    @Autowired
    private FileConsumerProperties fileConsumerProperties;
    @Autowired
    Source source;

    @Bean
    public IntegrationFlow fileSourceFlow() {
        FileInboundChannelAdapterSpec messageSourceSpec = Files.inboundAdapter((File)new File(this.properties.getDirectory()));
        if (StringUtils.hasText((String)this.properties.getFilenamePattern())) {
            messageSourceSpec.patternFilter(this.properties.getFilenamePattern());
        } else if (this.properties.getFilenameRegex() != null) {
            messageSourceSpec.regexFilter(this.properties.getFilenameRegex().pattern());
        }
        messageSourceSpec.preventDuplicates(this.properties.isPreventDuplicates());
        IntegrationFlowBuilder flowBuilder = IntegrationFlows.from((MessageSourceSpec)messageSourceSpec);
        if (this.fileConsumerProperties.getMode() != FileReadingMode.ref) {
            flowBuilder = FileUtils.enhanceFlowForReadingMode((IntegrationFlowBuilder)flowBuilder, (FileConsumerProperties)this.fileConsumerProperties);
        }
        return ((IntegrationFlowBuilder)flowBuilder.channel(this.source.output())).get();
    }
}

