/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.app.file.source;

import java.io.File;
import java.util.regex.Pattern;
import javax.validation.constraints.AssertTrue;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(value="file")
public class FileSourceProperties {
    private static final String DEFAULT_DIR = System.getProperty("java.io.tmpdir") + File.separator + "dataflow" + File.separator + "input";
    private String directory = DEFAULT_DIR;
    private boolean preventDuplicates = true;
    private String filenamePattern;
    private Pattern filenameRegex;

    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    public boolean isPreventDuplicates() {
        return this.preventDuplicates;
    }

    public void setPreventDuplicates(boolean preventDuplicates) {
        this.preventDuplicates = preventDuplicates;
    }

    public String getFilenamePattern() {
        return this.filenamePattern;
    }

    public void setFilenamePattern(String filenamePattern) {
        this.filenamePattern = filenamePattern;
    }

    public Pattern getFilenameRegex() {
        return this.filenameRegex;
    }

    public void setFilenameRegex(Pattern filenameRegex) {
        this.filenameRegex = filenameRegex;
    }

    @AssertTrue(message="filenamePattern and filenameRegex are mutually exclusive")
    public boolean isExclusivePatterns() {
        return this.filenamePattern == null || this.filenameRegex == null;
    }
}

