/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.app.file.source;

import java.io.File;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.stream.annotation.EnableBinding;
import org.springframework.cloud.stream.app.file.FileConsumerProperties;
import org.springframework.cloud.stream.app.file.FileUtils;
import org.springframework.cloud.stream.app.file.source.FileSourceProperties;
import org.springframework.cloud.stream.app.trigger.TriggerConfiguration;
import org.springframework.cloud.stream.app.trigger.TriggerPropertiesMaxMessagesDefaultUnlimited;
import org.springframework.cloud.stream.messaging.Source;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.integration.dsl.IntegrationFlow;
import org.springframework.integration.dsl.IntegrationFlowBuilder;
import org.springframework.integration.dsl.IntegrationFlows;
import org.springframework.integration.dsl.SourcePollingChannelAdapterSpec;
import org.springframework.integration.dsl.core.MessageSourceSpec;
import org.springframework.integration.dsl.file.FileInboundChannelAdapterSpec;
import org.springframework.integration.dsl.file.Files;
import org.springframework.integration.dsl.support.Consumer;
import org.springframework.integration.scheduling.PollerMetadata;
import org.springframework.util.StringUtils;

@EnableBinding(value={Source.class})
@Import(value={TriggerConfiguration.class})
@EnableConfigurationProperties(value={FileSourceProperties.class, FileConsumerProperties.class, TriggerPropertiesMaxMessagesDefaultUnlimited.class})
public class FileSourceConfiguration {
    @Autowired
    private FileSourceProperties properties;
    @Autowired
    private FileConsumerProperties fileConsumerProperties;
    @Autowired
    @Qualifier(value="defaultPoller")
    PollerMetadata defaultPoller;
    @Autowired
    Source source;

    @Bean
    public IntegrationFlow fileSourceFlow() {
        FileInboundChannelAdapterSpec messageSourceSpec = Files.inboundAdapter((File)new File(this.properties.getDirectory()));
        if (StringUtils.hasText((String)this.properties.getFilenamePattern())) {
            messageSourceSpec.patternFilter(this.properties.getFilenamePattern());
        } else if (this.properties.getFilenameRegex() != null) {
            messageSourceSpec.regexFilter(this.properties.getFilenameRegex().pattern());
        }
        if (this.properties.isPreventDuplicates()) {
            messageSourceSpec.preventDuplicates();
        }
        IntegrationFlowBuilder flowBuilder = IntegrationFlows.from((MessageSourceSpec)messageSourceSpec, (Consumer)new Consumer<SourcePollingChannelAdapterSpec>(){

            public void accept(SourcePollingChannelAdapterSpec sourcePollingChannelAdapterSpec) {
                sourcePollingChannelAdapterSpec.poller(FileSourceConfiguration.this.defaultPoller);
            }
        });
        return ((IntegrationFlowBuilder)FileUtils.enhanceFlowForReadingMode((IntegrationFlowBuilder)flowBuilder, (FileConsumerProperties)this.fileConsumerProperties).channel(this.source.output())).get();
    }
}

