/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.app.websocket.sink;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.SelfSignedCertificate;
import java.io.File;
import java.security.cert.CertificateException;
import javax.net.ssl.SSLException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.stream.app.websocket.sink.WebsocketSinkProperties;
import org.springframework.cloud.stream.app.websocket.sink.WebsocketSinkServerHandler;
import org.springframework.cloud.stream.app.websocket.sink.trace.InMemoryTraceRepository;

public class WebsocketSinkServerInitializer
extends ChannelInitializer<SocketChannel> {
    public static final int MAX_CONTENT_LENGTH = 65536;
    private final InMemoryTraceRepository traceRepository;
    @Autowired
    private WebsocketSinkProperties properties;
    @Value(value="${endpoints.websocketsinktrace.enabled:false}")
    private boolean traceEnabled;

    public WebsocketSinkServerInitializer(InMemoryTraceRepository traceRepository) {
        this.traceRepository = traceRepository;
    }

    public void initChannel(SocketChannel ch) throws Exception {
        ChannelPipeline pipeline = ch.pipeline();
        SslContext sslCtx = this.configureSslContext();
        if (sslCtx != null) {
            pipeline.addLast(new ChannelHandler[]{sslCtx.newHandler(ch.alloc())});
        }
        pipeline.addLast(new ChannelHandler[]{new HttpServerCodec()});
        pipeline.addLast(new ChannelHandler[]{new HttpObjectAggregator(65536)});
        pipeline.addLast(new ChannelHandler[]{new WebsocketSinkServerHandler(this.traceRepository, this.properties, this.traceEnabled)});
    }

    private SslContext configureSslContext() throws CertificateException, SSLException {
        if (this.properties.isSsl()) {
            SelfSignedCertificate ssc = new SelfSignedCertificate();
            return SslContextBuilder.forServer((File)ssc.certificate(), (File)ssc.privateKey()).build();
        }
        return null;
    }
}

