/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.app.websocket.sink.actuator;

import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.stream.app.websocket.sink.trace.InMemoryTraceRepository;
import org.springframework.cloud.stream.app.websocket.sink.trace.Trace;

@ConfigurationProperties(prefix="endpoints.websocketsinktrace")
@Endpoint(id="websocketsinktrace")
public class WebsocketSinkTraceEndpoint {
    private static final Log logger = LogFactory.getLog(WebsocketSinkTraceEndpoint.class);
    private boolean enabled;
    private final InMemoryTraceRepository repository;

    public WebsocketSinkTraceEndpoint(InMemoryTraceRepository repository) {
        this.repository = repository;
        logger.info((Object)String.format("/websocketsinktrace enabled: %b", this.enabled));
    }

    @PostConstruct
    public void init() {
    }

    @ReadOperation
    public List<Trace> traces() {
        return this.repository.findAll();
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

