/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.app.tcp.sink;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.stream.annotation.EnableBinding;
import org.springframework.cloud.stream.app.tcp.EncoderDecoderFactoryBean;
import org.springframework.cloud.stream.app.tcp.TcpConnectionFactoryProperties;
import org.springframework.cloud.stream.app.tcp.sink.TcpSinkProperties;
import org.springframework.cloud.stream.messaging.Sink;
import org.springframework.context.annotation.Bean;
import org.springframework.core.serializer.Serializer;
import org.springframework.integration.annotation.ServiceActivator;
import org.springframework.integration.ip.config.TcpConnectionFactoryFactoryBean;
import org.springframework.integration.ip.tcp.TcpSendingMessageHandler;
import org.springframework.integration.ip.tcp.connection.AbstractConnectionFactory;
import org.springframework.integration.ip.tcp.connection.TcpMessageMapper;
import org.springframework.integration.ip.tcp.serializer.AbstractByteArraySerializer;

@EnableBinding(value={Sink.class})
@EnableConfigurationProperties(value={TcpSinkProperties.class, TcpConnectionFactoryProperties.class})
public class TcpSinkConfiguration {
    @Autowired
    private TcpSinkProperties properties;
    @Autowired
    private TcpConnectionFactoryProperties tcpConnectionProperties;

    @Bean
    @ServiceActivator(inputChannel="input")
    public TcpSendingMessageHandler handler(@Qualifier(value="tcpSinkConnectionFactory") AbstractConnectionFactory connectionFactory) {
        TcpSendingMessageHandler handler = new TcpSendingMessageHandler();
        handler.setConnectionFactory(connectionFactory);
        return handler;
    }

    @Bean
    public TcpConnectionFactoryFactoryBean tcpSinkConnectionFactory(@Qualifier(value="tcpSinkEncoder") AbstractByteArraySerializer encoder, @Qualifier(value="tcpSinkMapper") TcpMessageMapper mapper) throws Exception {
        TcpConnectionFactoryFactoryBean factoryBean = new TcpConnectionFactoryFactoryBean();
        factoryBean.setType("client");
        factoryBean.setHost(this.properties.getHost());
        factoryBean.setPort(this.tcpConnectionProperties.getPort());
        factoryBean.setUsingNio(this.tcpConnectionProperties.isNio());
        factoryBean.setUsingDirectBuffers(this.tcpConnectionProperties.isUseDirectBuffers());
        factoryBean.setLookupHost(this.tcpConnectionProperties.isReverseLookup());
        factoryBean.setSerializer((Serializer)encoder);
        factoryBean.setSoTimeout(this.tcpConnectionProperties.getSocketTimeout());
        factoryBean.setMapper(mapper);
        factoryBean.setSingleUse(this.properties.isClose());
        return factoryBean;
    }

    @Bean
    public EncoderDecoderFactoryBean tcpSinkEncoder() {
        return new EncoderDecoderFactoryBean(this.properties.getEncoder());
    }

    @Bean
    public TcpMessageMapper tcpSinkMapper() {
        TcpMessageMapper mapper = new TcpMessageMapper();
        mapper.setCharset(this.properties.getCharset());
        return mapper;
    }
}

