/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.app.sftp.sink;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.Range;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.expression.Expression;
import org.springframework.integration.file.support.FileExistsMode;
import org.springframework.validation.annotation.Validated;

@ConfigurationProperties(value="sftp")
@Validated
public class SftpSinkProperties {
    private final Factory factory = new Factory();
    private String temporaryRemoteDir = "/";
    private boolean autoCreateDir = true;
    private FileExistsMode mode = FileExistsMode.REPLACE;
    private boolean useTemporaryFilename = true;
    private Expression filenameExpression;
    private String remoteDir = "/";
    private String tmpFileSuffix = ".tmp";
    private String remoteFileSeparator = "/";

    @NotBlank
    public String getTemporaryRemoteDir() {
        return this.temporaryRemoteDir;
    }

    public void setTemporaryRemoteDir(String temporaryRemoteDir) {
        this.temporaryRemoteDir = temporaryRemoteDir;
    }

    public boolean isAutoCreateDir() {
        return this.autoCreateDir;
    }

    public void setAutoCreateDir(boolean autoCreateDir) {
        this.autoCreateDir = autoCreateDir;
    }

    @NotNull
    public FileExistsMode getMode() {
        return this.mode;
    }

    public void setMode(FileExistsMode mode) {
        this.mode = mode;
    }

    public boolean isUseTemporaryFilename() {
        return this.useTemporaryFilename;
    }

    public void setUseTemporaryFilename(boolean useTemporaryFilename) {
        this.useTemporaryFilename = useTemporaryFilename;
    }

    public Expression getFilenameExpression() {
        return this.filenameExpression;
    }

    public void setFilenameExpression(Expression filenameExpression) {
        this.filenameExpression = filenameExpression;
    }

    @NotBlank
    public String getRemoteDir() {
        return this.remoteDir;
    }

    public final void setRemoteDir(String remoteDir) {
        this.remoteDir = remoteDir;
    }

    @NotBlank
    public String getTmpFileSuffix() {
        return this.tmpFileSuffix;
    }

    public void setTmpFileSuffix(String tmpFileSuffix) {
        this.tmpFileSuffix = tmpFileSuffix;
    }

    @NotBlank
    public String getRemoteFileSeparator() {
        return this.remoteFileSeparator;
    }

    public void setRemoteFileSeparator(String remoteFileSeparator) {
        this.remoteFileSeparator = remoteFileSeparator;
    }

    public Factory getFactory() {
        return this.factory;
    }

    public static class Factory {
        private String host = "localhost";
        private String username;
        private String password;
        private Boolean cacheSessions;
        private int port = 22;
        private String privateKey = "";
        private String passPhrase = "";
        private boolean allowUnknownKeys = false;
        private Expression knownHostsExpression = null;

        @NotBlank
        public String getHost() {
            return this.host;
        }

        public void setHost(String host) {
            this.host = host;
        }

        @NotBlank
        public String getUsername() {
            return this.username;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public Boolean getCacheSessions() {
            return this.cacheSessions;
        }

        public void setCacheSessions(Boolean cacheSessions) {
            this.cacheSessions = cacheSessions;
        }

        @Range(min=0L, max=65535L)
        public @Range(min=0L, max=65535L) int getPort() {
            return this.port;
        }

        public void setPort(int port) {
            this.port = port;
        }

        public String getPrivateKey() {
            return this.privateKey;
        }

        public void setPrivateKey(String privateKey) {
            this.privateKey = privateKey;
        }

        public String getPassPhrase() {
            return this.passPhrase;
        }

        public void setPassPhrase(String passPhrase) {
            this.passPhrase = passPhrase;
        }

        public boolean isAllowUnknownKeys() {
            return this.allowUnknownKeys;
        }

        public void setAllowUnknownKeys(boolean allowUnknownKeys) {
            this.allowUnknownKeys = allowUnknownKeys;
        }

        public Expression getKnownHostsExpression() {
            return this.knownHostsExpression;
        }

        public void setKnownHostsExpression(Expression knownHosts) {
            this.knownHostsExpression = knownHosts;
        }
    }
}

