/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.app.s3.sink;

import com.amazonaws.services.s3.model.CannedAccessControlList;
import javax.validation.constraints.AssertTrue;
import org.hibernate.validator.constraints.Length;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.expression.Expression;
import org.springframework.validation.annotation.Validated;

@ConfigurationProperties(value="s3")
@Validated
public class AmazonS3SinkProperties {
    private String bucket;
    private Expression bucketExpression;
    private Expression keyExpression;
    private CannedAccessControlList acl;
    private Expression aclExpression;

    @Length(min=3)
    public String getBucket() {
        return this.bucket;
    }

    public void setBucket(String bucket) {
        this.bucket = bucket;
    }

    public Expression getBucketExpression() {
        return this.bucketExpression;
    }

    public void setBucketExpression(Expression bucketExpression) {
        this.bucketExpression = bucketExpression;
    }

    public Expression getKeyExpression() {
        return this.keyExpression;
    }

    public void setKeyExpression(Expression keyExpression) {
        this.keyExpression = keyExpression;
    }

    public CannedAccessControlList getAcl() {
        return this.acl;
    }

    public void setAcl(CannedAccessControlList acl) {
        this.acl = acl;
    }

    public Expression getAclExpression() {
        return this.aclExpression;
    }

    public void setAclExpression(Expression aclExpression) {
        this.aclExpression = aclExpression;
    }

    @AssertTrue(message="Exactly one of 'bucket' or 'bucketExpression' must be set")
    public boolean isMutuallyExclusiveBucketAndBucketExpression() {
        return this.bucket != null && this.bucketExpression == null || this.bucket == null && this.bucketExpression != null;
    }

    @AssertTrue(message="Only one of 'acl' or 'aclExpression' must be set")
    public boolean isMutuallyExclusiveAclAndAclExpression() {
        return this.acl == null || this.aclExpression == null;
    }
}

