/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.app.router.sink;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.stream.annotation.EnableBinding;
import org.springframework.cloud.stream.app.router.sink.RouterSinkProperties;
import org.springframework.cloud.stream.binding.BinderAwareChannelResolver;
import org.springframework.cloud.stream.messaging.Sink;
import org.springframework.context.annotation.Bean;
import org.springframework.integration.annotation.ServiceActivator;
import org.springframework.integration.groovy.GroovyScriptExecutingMessageProcessor;
import org.springframework.integration.router.AbstractMappingMessageRouter;
import org.springframework.integration.router.ExpressionEvaluatingRouter;
import org.springframework.integration.router.MethodInvokingRouter;
import org.springframework.integration.scripting.RefreshableResourceScriptSource;
import org.springframework.integration.scripting.ScriptVariableGenerator;
import org.springframework.messaging.core.DestinationResolver;
import org.springframework.scripting.ScriptSource;

@EnableBinding(value={Sink.class})
@EnableConfigurationProperties(value={RouterSinkProperties.class})
public class RouterSinkConfiguration {
    @Autowired
    Sink channels;

    @Bean
    @ServiceActivator(inputChannel="input")
    public AbstractMappingMessageRouter router(BinderAwareChannelResolver channelResolver, ScriptVariableGenerator scriptVariableGenerator, RouterSinkProperties properties) {
        Object router = properties.getScript() != null ? new MethodInvokingRouter((Object)this.scriptProcessor(scriptVariableGenerator, properties)) : new ExpressionEvaluatingRouter(properties.getExpression());
        router.setDefaultOutputChannelName(properties.getDefaultOutputChannel());
        router.setResolutionRequired(properties.isResolutionRequired());
        if (properties.getDestinationMappings() != null) {
            router.replaceChannelMappings(properties.getDestinationMappings());
        }
        router.setChannelResolver((DestinationResolver)channelResolver);
        return router;
    }

    @Bean
    @ConditionalOnProperty(value={"router.script"})
    public GroovyScriptExecutingMessageProcessor scriptProcessor(ScriptVariableGenerator scriptVariableGenerator, RouterSinkProperties properties) {
        RefreshableResourceScriptSource scriptSource = new RefreshableResourceScriptSource(properties.getScript(), (long)properties.getRefreshDelay());
        return new GroovyScriptExecutingMessageProcessor((ScriptSource)scriptSource, scriptVariableGenerator);
    }
}

