/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.app.redis.sink;

import java.util.Arrays;
import java.util.Collections;
import javax.validation.constraints.AssertTrue;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.expression.Expression;
import org.springframework.expression.common.LiteralExpression;
import org.springframework.util.StringUtils;
import org.springframework.validation.annotation.Validated;

@ConfigurationProperties(value="redis")
@Validated
public class RedisSinkProperties {
    private Expression topicExpression;
    private Expression queueExpression;
    private Expression keyExpression;
    private String key;
    private String queue;
    private String topic;

    public void setKey(String key) {
        this.key = key;
    }

    public void setQueue(String queue) {
        this.queue = queue;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public Expression keyExpression() {
        return this.key != null ? new LiteralExpression(this.key) : this.keyExpression;
    }

    public void setKeyExpression(Expression keyExpression) {
        this.keyExpression = keyExpression;
    }

    public Expression queueExpression() {
        return this.queue != null ? new LiteralExpression(this.queue) : this.queueExpression;
    }

    public void setQueueExpression(Expression queueExpression) {
        this.queueExpression = queueExpression;
    }

    public Expression topicExpression() {
        return this.topic != null ? new LiteralExpression(this.topic) : this.topicExpression;
    }

    public void setTopicExpression(Expression topicExpression) {
        this.topicExpression = topicExpression;
    }

    boolean isKeyPresent() {
        return StringUtils.hasText((String)this.key) || this.keyExpression != null;
    }

    boolean isQueuePresent() {
        return StringUtils.hasText((String)this.queue) || this.queueExpression != null;
    }

    boolean isTopicPresent() {
        return StringUtils.hasText((String)this.topic) || this.topicExpression != null;
    }

    public Expression getTopicExpression() {
        return this.topicExpression;
    }

    public Expression getQueueExpression() {
        return this.queueExpression;
    }

    public Expression getKeyExpression() {
        return this.keyExpression;
    }

    public String getKey() {
        return this.key;
    }

    public String getQueue() {
        return this.queue;
    }

    public String getTopic() {
        return this.topic;
    }

    @AssertTrue(message="Exactly one of 'queue', 'queueExpression', 'key', 'keyExpression', 'topic' and 'topicExpression' must be set")
    public @AssertTrue(message="Exactly one of 'queue', 'queueExpression', 'key', 'keyExpression', 'topic' and 'topicExpression' must be set") boolean isMutuallyExclusive() {
        Object[] props = new Object[]{this.queue, this.queueExpression, this.key, this.keyExpression, this.topic, this.topicExpression};
        return props.length - 1 == Collections.frequency(Arrays.asList(props), null);
    }
}

