/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.app.redis.sink;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.stream.annotation.EnableBinding;
import org.springframework.cloud.stream.app.redis.sink.RedisSinkProperties;
import org.springframework.cloud.stream.messaging.Sink;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.integration.annotation.ServiceActivator;
import org.springframework.integration.redis.outbound.RedisPublishingMessageHandler;
import org.springframework.integration.redis.outbound.RedisQueueOutboundChannelAdapter;
import org.springframework.integration.redis.outbound.RedisStoreWritingMessageHandler;
import org.springframework.messaging.MessageHandler;

@Configuration
@EnableConfigurationProperties(value={RedisSinkProperties.class})
@EnableBinding(value={Sink.class})
public class RedisSinkConfiguration {
    @Autowired
    private RedisConnectionFactory redisConnectionFactory;
    @Autowired
    private RedisSinkProperties redisSinkProperties;

    @Bean
    @ServiceActivator(inputChannel="input")
    public MessageHandler redisSinkMessageHandler() {
        if (this.redisSinkProperties.isKeyPresent()) {
            RedisStoreWritingMessageHandler redisStoreWritingMessageHandler = new RedisStoreWritingMessageHandler(this.redisConnectionFactory);
            redisStoreWritingMessageHandler.setKeyExpression(this.redisSinkProperties.keyExpression());
            return redisStoreWritingMessageHandler;
        }
        if (this.redisSinkProperties.isQueuePresent()) {
            return new RedisQueueOutboundChannelAdapter(this.redisSinkProperties.queueExpression(), this.redisConnectionFactory);
        }
        RedisPublishingMessageHandler redisPublishingMessageHandler = new RedisPublishingMessageHandler(this.redisConnectionFactory);
        redisPublishingMessageHandler.setTopicExpression(this.redisSinkProperties.topicExpression());
        return redisPublishingMessageHandler;
    }
}

