/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.app.rabbit.sink;

import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageDeliveryMode;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.rabbit.connection.CachingConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionNameStrategy;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.support.converter.MessageConversionException;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.amqp.RabbitAutoConfiguration;
import org.springframework.boot.autoconfigure.amqp.RabbitProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.stream.annotation.EnableBinding;
import org.springframework.cloud.stream.app.rabbit.sink.RabbitSinkProperties;
import org.springframework.cloud.stream.messaging.Sink;
import org.springframework.context.annotation.Bean;
import org.springframework.expression.Expression;
import org.springframework.integration.amqp.dsl.Amqp;
import org.springframework.integration.amqp.dsl.AmqpOutboundEndpointSpec;
import org.springframework.integration.annotation.ServiceActivator;
import org.springframework.messaging.MessageHandler;
import org.springframework.util.Assert;

@EnableBinding(value={Sink.class})
@EnableConfigurationProperties(value={RabbitSinkProperties.class})
public class RabbitSinkConfiguration
implements DisposableBean {
    @Autowired
    private RabbitProperties bootProperties;
    @Autowired
    private ObjectProvider<ConnectionNameStrategy> connectionNameStrategy;
    @Autowired
    private RabbitSinkProperties properties;
    private CachingConnectionFactory ownConnectionFactory;

    @ServiceActivator(inputChannel="input")
    @Bean
    public MessageHandler amqpChannelAdapter(ConnectionFactory rabbitConnectionFactory) throws Exception {
        AmqpOutboundEndpointSpec handler = (AmqpOutboundEndpointSpec)((AmqpOutboundEndpointSpec)Amqp.outboundAdapter((AmqpTemplate)this.rabbitTemplate(this.properties.isOwnConnection() ? this.buildLocalConnectionFactory() : rabbitConnectionFactory)).mappedRequestHeaders(this.properties.getMappedRequestHeaders())).defaultDeliveryMode(this.properties.getPersistentDeliveryMode() ? MessageDeliveryMode.PERSISTENT : MessageDeliveryMode.NON_PERSISTENT);
        Expression exchangeExpression = this.properties.getExchangeExpression();
        if (exchangeExpression != null) {
            handler.exchangeNameExpression(exchangeExpression);
        } else {
            handler.exchangeName(this.properties.getExchange());
        }
        Expression routingKeyExpression = this.properties.getRoutingKeyExpression();
        if (routingKeyExpression != null) {
            handler.routingKeyExpression(routingKeyExpression);
        } else {
            handler.routingKey(this.properties.getRoutingKey());
        }
        return (MessageHandler)handler.get();
    }

    private ConnectionFactory buildLocalConnectionFactory() throws Exception {
        this.ownConnectionFactory = new AutoConfig.Creator().rabbitConnectionFactory(this.bootProperties, this.connectionNameStrategy);
        return this.ownConnectionFactory;
    }

    @Bean
    public RabbitTemplate rabbitTemplate(ConnectionFactory rabbitConnectionFactory) {
        RabbitTemplate rabbitTemplate = new RabbitTemplate(rabbitConnectionFactory);
        rabbitTemplate.setMessageConverter((MessageConverter)new PassThroughMessageConverter());
        return rabbitTemplate;
    }

    public void destroy() {
        if (this.ownConnectionFactory != null) {
            this.ownConnectionFactory.destroy();
        }
    }

    private static class PassThroughMessageConverter
    implements MessageConverter {
        private PassThroughMessageConverter() {
        }

        public Message toMessage(Object body, MessageProperties messageProperties) throws MessageConversionException {
            Assert.isInstanceOf(byte[].class, (Object)body, (String)"The 'PassThroughMessageConverter' supports only byte[] objects.");
            return new Message((byte[])body, messageProperties);
        }

        public Object fromMessage(Message message) throws MessageConversionException {
            throw new UnsupportedOperationException();
        }
    }

    private static class AutoConfig
    extends RabbitAutoConfiguration {
        private AutoConfig() {
        }

        private static class Creator
        extends RabbitAutoConfiguration.RabbitConnectionFactoryCreator {
            private Creator() {
            }

            public CachingConnectionFactory rabbitConnectionFactory(RabbitProperties config, ObjectProvider<ConnectionNameStrategy> connectionNameStrategy) throws Exception {
                CachingConnectionFactory cf = super.rabbitConnectionFactory(config, connectionNameStrategy);
                cf.setConnectionNameStrategy(connectionFactory -> "rabbit.sink.own.connection");
                cf.afterPropertiesSet();
                return cf;
            }
        }
    }
}

