/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.app.rabbit.sink;

import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.amqp.core.MessageDeliveryMode;
import org.springframework.amqp.rabbit.connection.CachingConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionNameStrategy;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.support.converter.Jackson2JsonMessageConverter;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.amqp.RabbitProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.stream.annotation.EnableBinding;
import org.springframework.cloud.stream.app.rabbit.sink.AutoConfig;
import org.springframework.cloud.stream.app.rabbit.sink.RabbitSinkProperties;
import org.springframework.cloud.stream.messaging.Sink;
import org.springframework.context.annotation.Bean;
import org.springframework.expression.Expression;
import org.springframework.integration.amqp.dsl.Amqp;
import org.springframework.integration.amqp.dsl.AmqpOutboundEndpointSpec;
import org.springframework.integration.annotation.ServiceActivator;
import org.springframework.messaging.MessageHandler;

@EnableBinding(value={Sink.class})
@EnableConfigurationProperties(value={RabbitSinkProperties.class})
public class RabbitSinkConfiguration
implements DisposableBean {
    @Autowired
    private RabbitProperties bootProperties;
    @Autowired
    private ObjectProvider<ConnectionNameStrategy> connectionNameStrategy;
    @Autowired
    private RabbitSinkProperties properties;
    @Value(value="#{${rabbit.converterBeanName:null}}")
    private MessageConverter messageConverter;
    private CachingConnectionFactory ownConnectionFactory;

    @ServiceActivator(inputChannel="input")
    @Bean
    public MessageHandler amqpChannelAdapter(ConnectionFactory rabbitConnectionFactory) throws Exception {
        AmqpOutboundEndpointSpec handler = (AmqpOutboundEndpointSpec)((AmqpOutboundEndpointSpec)Amqp.outboundAdapter((AmqpTemplate)this.rabbitTemplate(this.properties.isOwnConnection() ? this.buildLocalConnectionFactory() : rabbitConnectionFactory)).mappedRequestHeaders(this.properties.getMappedRequestHeaders())).defaultDeliveryMode(this.properties.getPersistentDeliveryMode() ? MessageDeliveryMode.PERSISTENT : MessageDeliveryMode.NON_PERSISTENT);
        Expression exchangeExpression = this.properties.getExchangeExpression();
        if (exchangeExpression != null) {
            handler.exchangeNameExpression(exchangeExpression);
        } else {
            handler.exchangeName(this.properties.getExchange());
        }
        Expression routingKeyExpression = this.properties.getRoutingKeyExpression();
        if (routingKeyExpression != null) {
            handler.routingKeyExpression(routingKeyExpression);
        } else {
            handler.routingKey(this.properties.getRoutingKey());
        }
        return (MessageHandler)handler.get();
    }

    private ConnectionFactory buildLocalConnectionFactory() throws Exception {
        this.ownConnectionFactory = new AutoConfig.Creator().rabbitConnectionFactory(this.bootProperties, this.connectionNameStrategy);
        return this.ownConnectionFactory;
    }

    @Bean
    public RabbitTemplate rabbitTemplate(ConnectionFactory rabbitConnectionFactory) {
        RabbitTemplate rabbitTemplate = new RabbitTemplate(rabbitConnectionFactory);
        if (this.messageConverter != null) {
            rabbitTemplate.setMessageConverter(this.messageConverter);
        }
        return rabbitTemplate;
    }

    @Bean
    @ConditionalOnProperty(name={"rabbit.converterBeanName"}, havingValue="jsonConverter")
    public Jackson2JsonMessageConverter jsonConverter() {
        return new Jackson2JsonMessageConverter();
    }

    public void destroy() throws Exception {
        if (this.ownConnectionFactory != null) {
            this.ownConnectionFactory.destroy();
        }
    }
}

