/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.app.rabbit.sink;

import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.amqp.core.MessageDeliveryMode;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.support.converter.Jackson2JsonMessageConverter;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.stream.annotation.EnableBinding;
import org.springframework.cloud.stream.app.rabbit.sink.RabbitSinkProperties;
import org.springframework.cloud.stream.messaging.Sink;
import org.springframework.context.annotation.Bean;
import org.springframework.integration.amqp.outbound.AmqpOutboundEndpoint;
import org.springframework.integration.amqp.support.AmqpHeaderMapper;
import org.springframework.integration.amqp.support.DefaultAmqpHeaderMapper;
import org.springframework.integration.annotation.ServiceActivator;
import org.springframework.messaging.MessageHandler;

@EnableBinding(value={Sink.class})
@EnableConfigurationProperties(value={RabbitSinkProperties.class})
public class RabbitSinkConfiguration {
    @Autowired
    private RabbitSinkProperties properties;
    @Value(value="#{${rabbit.converterBeanName:null}}")
    private MessageConverter messageConverter;

    @ServiceActivator(inputChannel="input")
    @Bean
    public MessageHandler amqpChannelAdapter(ConnectionFactory rabbitConnectionFactory) {
        AmqpOutboundEndpoint handler = new AmqpOutboundEndpoint((AmqpTemplate)this.rabbitTemplate(rabbitConnectionFactory));
        DefaultAmqpHeaderMapper mapper = new DefaultAmqpHeaderMapper();
        mapper.setRequestHeaderNames(this.properties.getMappedRequestHeaders());
        handler.setHeaderMapper((AmqpHeaderMapper)mapper);
        handler.setDefaultDeliveryMode(this.properties.getPersistentDeliveryMode() ? MessageDeliveryMode.PERSISTENT : MessageDeliveryMode.NON_PERSISTENT);
        if (this.properties.getExchangeExpression() == null) {
            handler.setExchangeName(this.properties.getExchange());
        } else {
            handler.setExpressionExchangeName(this.properties.getExchangeExpression());
        }
        if (this.properties.getRoutingKeyExpression() == null) {
            handler.setRoutingKey(this.properties.getRoutingKey());
        } else {
            handler.setExpressionRoutingKey(this.properties.getRoutingKeyExpression());
        }
        return handler;
    }

    @Bean
    public RabbitTemplate rabbitTemplate(ConnectionFactory rabbitConnectionFactory) {
        RabbitTemplate rabbitTemplate = new RabbitTemplate(rabbitConnectionFactory);
        if (this.messageConverter != null) {
            rabbitTemplate.setMessageConverter(this.messageConverter);
        }
        return rabbitTemplate;
    }

    @Bean
    @ConditionalOnProperty(name={"rabbit.converterBeanName"}, havingValue="jsonConverter")
    public Jackson2JsonMessageConverter jsonConverter() {
        return new Jackson2JsonMessageConverter();
    }
}

