/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.app.hdfs.sink;

import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.stream.annotation.EnableBinding;
import org.springframework.cloud.stream.app.hdfs.hadoop.store.DataStoreWriter;
import org.springframework.cloud.stream.app.hdfs.sink.DataStoreWriterFactoryBean;
import org.springframework.cloud.stream.app.hdfs.sink.HdfsSinkProperties;
import org.springframework.cloud.stream.messaging.Sink;
import org.springframework.context.annotation.Bean;
import org.springframework.core.task.TaskExecutor;
import org.springframework.integration.annotation.ServiceActivator;
import org.springframework.messaging.handler.annotation.Payload;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

@EnableBinding(value={Sink.class})
@EnableConfigurationProperties(value={HdfsSinkProperties.class})
public class HdfsSinkConfiguration {
    public static final String TASK_SCHEDULER_BEAN = "hdfsSinkTaskScheduler";
    public static final String TASK_EXECUTOR_BEAN = "TASK_EXECUTOR_BEAN";
    private DataStoreWriter<String> dataStoreWriter;

    @Bean(value={"hdfsSinkTaskScheduler"})
    public TaskScheduler taskScheduler() {
        return new ThreadPoolTaskScheduler();
    }

    @Bean(value={"TASK_EXECUTOR_BEAN"})
    public TaskExecutor taskExecutor() {
        return new ThreadPoolTaskExecutor();
    }

    @Bean
    public DataStoreWriterFactoryBean dataStoreWriter() {
        return new DataStoreWriterFactoryBean();
    }

    @Autowired
    public void setDataStoreWriter(DataStoreWriter<String> dataStoreWriter) {
        this.dataStoreWriter = dataStoreWriter;
    }

    @ServiceActivator(inputChannel="input")
    public void hdfsSink(@Payload String payload) {
        try {
            this.dataStoreWriter.write((Object)payload);
        }
        catch (IOException e) {
            throw new IllegalStateException("Error while writing", e);
        }
    }
}

