/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.app.gpfdist.sink.support;

import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.cloud.stream.app.gpfdist.sink.support.ControlFile;
import org.springframework.util.StringUtils;

public class GreenplumDataSourceFactoryBean
extends AbstractFactoryBean<BasicDataSource> {
    private ControlFile controlFile;
    private String dbHost = "localhost";
    private String dbName = "gpadmin";
    private String dbUser = "gpadmin";
    private String dbPassword = "gpadmin";
    private int dbPort = 5432;

    public Class<DataSource> getObjectType() {
        return DataSource.class;
    }

    protected BasicDataSource createInstance() throws Exception {
        BasicDataSource ds = new BasicDataSource();
        ds.setDriverClassName("org.postgresql.Driver");
        if (StringUtils.hasText((String)this.dbUser)) {
            ds.setUsername(this.dbUser);
        }
        if (StringUtils.hasText((String)this.dbPassword)) {
            ds.setPassword(this.dbPassword);
        }
        ds.setUrl("jdbc:postgresql://" + this.dbHost + ":" + this.dbPort + "/" + this.dbName);
        return ds;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.controlFile != null) {
            if (StringUtils.hasText((String)this.controlFile.getHost())) {
                this.dbHost = this.controlFile.getHost();
            }
            if (StringUtils.hasText((String)this.controlFile.getDatabase())) {
                this.dbName = this.controlFile.getDatabase();
            }
            if (StringUtils.hasText((String)this.controlFile.getUser())) {
                this.dbUser = this.controlFile.getUser();
            }
            if (StringUtils.hasText((String)this.controlFile.getPassword())) {
                this.dbPassword = this.controlFile.getPassword();
            }
            if (this.controlFile.getPort() != null) {
                this.dbPort = this.controlFile.getPort();
            }
        }
        super.afterPropertiesSet();
    }

    protected void destroyInstance(BasicDataSource instance) throws Exception {
        instance.close();
    }

    public void setControlFile(ControlFile controlFile) {
        this.controlFile = controlFile;
    }

    public void setDbHost(String dbHost) {
        this.dbHost = dbHost;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public void setDbUser(String dbUser) {
        this.dbUser = dbUser;
    }

    public void setDbPassword(String dbPassword) {
        this.dbPassword = dbPassword;
    }

    public void setDbPort(int dbPort) {
        this.dbPort = dbPort;
    }
}

