/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.app.gpfdist.sink.support;

import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.cloud.stream.app.gpfdist.sink.support.ControlFile;
import org.springframework.cloud.stream.app.gpfdist.sink.support.LoadConfiguration;
import org.springframework.cloud.stream.app.gpfdist.sink.support.Mode;
import org.springframework.cloud.stream.app.gpfdist.sink.support.ReadableTable;
import org.springframework.util.StringUtils;

public class LoadConfigurationFactoryBean
implements FactoryBean<LoadConfiguration>,
InitializingBean {
    private ControlFile controlFile;
    private String table;
    private String columns;
    private ReadableTable externalTable;
    private Mode mode = Mode.INSERT;
    private List<String> matchColumns;
    private List<String> updateColumns;
    private String updateCondition;
    private List<String> sqlBefore;
    private List<String> sqlAfter;

    public void afterPropertiesSet() throws Exception {
        if (this.controlFile != null) {
            if (this.controlFile.getGploadOutputMode() != null) {
                if (this.controlFile.getGploadOutputMode() == ControlFile.OutputMode.INSERT) {
                    this.mode = Mode.INSERT;
                } else if (this.controlFile.getGploadOutputMode() == ControlFile.OutputMode.UPDATE) {
                    this.mode = Mode.UPDATE;
                }
            }
            if (StringUtils.hasText((String)this.controlFile.getGploadOutputTable())) {
                this.table = this.controlFile.getGploadOutputTable();
            }
            if (this.controlFile.getGploadOutputMatchColumns() != null) {
                this.matchColumns = this.controlFile.getGploadOutputMatchColumns();
            }
            if (this.controlFile.getGploadOutputUpdateColumns() != null) {
                this.updateColumns = this.controlFile.getGploadOutputUpdateColumns();
            }
            if (StringUtils.hasText((String)this.controlFile.getGploadOutputUpdateCondition())) {
                this.updateCondition = this.controlFile.getGploadOutputUpdateCondition();
            }
            if (!this.controlFile.getGploadSqlBefore().isEmpty()) {
                this.sqlBefore = this.controlFile.getGploadSqlBefore();
            }
            if (!this.controlFile.getGploadSqlAfter().isEmpty()) {
                this.sqlAfter = this.controlFile.getGploadSqlAfter();
            }
        }
    }

    public LoadConfiguration getObject() throws Exception {
        LoadConfiguration loadConfiguration = new LoadConfiguration(this.table, this.columns, this.externalTable, this.mode, this.matchColumns, this.updateColumns, this.updateCondition);
        loadConfiguration.setSqlBefore(this.sqlBefore);
        loadConfiguration.setSqlAfter(this.sqlAfter);
        return loadConfiguration;
    }

    public Class<LoadConfiguration> getObjectType() {
        return LoadConfiguration.class;
    }

    public boolean isSingleton() {
        return false;
    }

    public void setControlFile(ControlFile controlFile) {
        this.controlFile = controlFile;
    }

    public String getTable() {
        return this.table;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public String getColumns() {
        return this.columns;
    }

    public void setColumns(String columns) {
        this.columns = columns;
    }

    public ReadableTable getExternalTable() {
        return this.externalTable;
    }

    public void setExternalTable(ReadableTable externalTable) {
        this.externalTable = externalTable;
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    public List<String> getMatchColumns() {
        return this.matchColumns;
    }

    public void setMatchColumns(String[] matchColumns) {
        this.matchColumns = Arrays.asList(matchColumns);
    }

    public List<String> getUpdateColumns() {
        return this.updateColumns;
    }

    public void setUpdateColumns(String[] updateColumns) {
        this.updateColumns = Arrays.asList(updateColumns);
    }

    public String getUpdateCondition() {
        return this.updateCondition;
    }

    public void setUpdateCondition(String updateCondition) {
        this.updateCondition = updateCondition;
    }

    public List<String> getSqlBefore() {
        return this.sqlBefore;
    }

    public void setSqlBefore(List<String> sqlBefore) {
        this.sqlBefore = sqlBefore;
    }

    public List<String> getSqlAfter() {
        return this.sqlAfter;
    }

    public void setSqlAfter(List<String> sqlAfter) {
        this.sqlAfter = sqlAfter;
    }
}

