/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.app.gpfdist.sink.support;

import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.YamlMapFactoryBean;
import org.springframework.cloud.stream.app.gpfdist.sink.support.ControlFile;
import org.springframework.core.io.Resource;

public class ControlFileFactoryBean
implements FactoryBean<ControlFile>,
InitializingBean {
    private ControlFile controlFile;
    private Resource controlFileResource;

    public void afterPropertiesSet() throws Exception {
        this.controlFile = this.controlFileResource != null ? this.parseYaml() : new ControlFile();
    }

    public ControlFile getObject() throws Exception {
        return this.controlFile;
    }

    public Class<ControlFile> getObjectType() {
        return ControlFile.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setControlFileResource(Resource controlFileResource) {
        this.controlFileResource = controlFileResource;
    }

    private ControlFile parseYaml() {
        ControlFile cf = new ControlFile();
        YamlMapFactoryBean factory = new YamlMapFactoryBean();
        factory.setResources(new Resource[]{this.controlFileResource});
        Map yaml = factory.getObject();
        for (Map.Entry e0 : yaml.entrySet()) {
            if (((String)e0.getKey()).toLowerCase().equals("gpload")) {
                if (!(e0.getValue() instanceof Map)) continue;
                Map gploadMap = (Map)e0.getValue();
                for (Map.Entry e1 : gploadMap.entrySet()) {
                    Map tableMap;
                    if (((String)e1.getKey()).toLowerCase().equals("output")) {
                        if (!(e1.getValue() instanceof List)) continue;
                        for (Object v : (List)e1.getValue()) {
                            if (!(v instanceof Map)) continue;
                            tableMap = (Map)v;
                            for (Map.Entry e2 : tableMap.entrySet()) {
                                if (((String)e2.getKey()).toLowerCase().equals("table")) {
                                    if (!(e2.getValue() instanceof String)) continue;
                                    cf.setGploadOutputTable((String)e2.getValue());
                                    continue;
                                }
                                if (((String)e2.getKey()).toLowerCase().equals("mode")) {
                                    if (!(e2.getValue() instanceof String)) continue;
                                    cf.setGploadOutputMode(ControlFile.OutputMode.valueOf(((String)e2.getValue()).toUpperCase()));
                                    continue;
                                }
                                if (((String)e2.getKey()).toLowerCase().equals("match_columns")) {
                                    if (!(e2.getValue() instanceof List)) continue;
                                    cf.setGploadOutputMatchColumns((List)e2.getValue());
                                    continue;
                                }
                                if (((String)e2.getKey()).toLowerCase().equals("update_columns")) {
                                    if (!(e2.getValue() instanceof List)) continue;
                                    cf.setGploadOutputUpdateColumns((List)e2.getValue());
                                    continue;
                                }
                                if (!((String)e2.getKey()).toLowerCase().equals("update_condition") || !(e2.getValue() instanceof String)) continue;
                                cf.setGploadOutputUpdateCondition((String)e2.getValue());
                            }
                        }
                        continue;
                    }
                    if (((String)e1.getKey()).toLowerCase().equals("input")) {
                        if (!(e1.getValue() instanceof List)) continue;
                        for (Object v : (List)e1.getValue()) {
                            if (!(v instanceof Map)) continue;
                            tableMap = (Map)v;
                            for (Map.Entry e2 : tableMap.entrySet()) {
                                if (!((String)e2.getKey()).toLowerCase().equals("delimiter")) continue;
                                if (e2.getValue() instanceof Character) {
                                    cf.setGploadInputDelimiter((Character)e2.getValue());
                                    continue;
                                }
                                if (!(e2.getValue() instanceof String) || ((String)e2.getValue()).length() != 1) continue;
                                cf.setGploadInputDelimiter(Character.valueOf(((String)e2.getValue()).charAt(0)));
                            }
                        }
                        continue;
                    }
                    if (!((String)e1.getKey()).toLowerCase().equals("sql") || !(e1.getValue() instanceof List)) continue;
                    for (Object v : (List)e1.getValue()) {
                        if (!(v instanceof Map)) continue;
                        Map sqlMap = (Map)v;
                        for (Map.Entry e2 : sqlMap.entrySet()) {
                            if (((String)e2.getKey()).toLowerCase().equals("before")) {
                                if (!(e2.getValue() instanceof String)) continue;
                                cf.addGploadSqlBefore((String)e2.getValue());
                                continue;
                            }
                            if (!((String)e2.getKey()).toLowerCase().equals("after") || !(e2.getValue() instanceof String)) continue;
                            cf.addGploadSqlAfter((String)e2.getValue());
                        }
                    }
                }
                continue;
            }
            if (((String)e0.getKey()).toLowerCase().equals("database")) {
                if (!(e0.getValue() instanceof String)) continue;
                cf.setDatabase((String)e0.getValue());
                continue;
            }
            if (((String)e0.getKey()).toLowerCase().equals("user")) {
                if (!(e0.getValue() instanceof String)) continue;
                cf.setUser((String)e0.getValue());
                continue;
            }
            if (((String)e0.getKey()).toLowerCase().equals("password")) {
                if (!(e0.getValue() instanceof String)) continue;
                cf.setPassword((String)e0.getValue());
                continue;
            }
            if (((String)e0.getKey()).toLowerCase().equals("host")) {
                if (!(e0.getValue() instanceof String)) continue;
                cf.setHost((String)e0.getValue());
                continue;
            }
            if (!((String)e0.getKey()).toLowerCase().equals("port") || !(e0.getValue() instanceof Integer)) continue;
            cf.setPort((Integer)e0.getValue());
        }
        return cf;
    }
}

