/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.app.gpfdist.sink;

import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.SmartLifecycle;
import org.springframework.integration.handler.AbstractMessageHandler;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHandlingException;

public abstract class AbstractGpfdistMessageHandler
extends AbstractMessageHandler
implements SmartLifecycle {
    private static final Log logger = LogFactory.getLog(AbstractGpfdistMessageHandler.class);
    private volatile boolean autoStartup = true;
    private volatile int phase = 0;
    private volatile boolean running;
    private final ReentrantLock lifecycleLock = new ReentrantLock();

    public final boolean isAutoStartup() {
        return this.autoStartup;
    }

    public final int getPhase() {
        return this.phase;
    }

    public final boolean isRunning() {
        this.lifecycleLock.lock();
        try {
            boolean bl = this.running;
            return bl;
        }
        finally {
            this.lifecycleLock.unlock();
        }
    }

    public final void start() {
        this.lifecycleLock.lock();
        try {
            if (!this.running) {
                this.doStart();
                this.running = true;
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("started " + (Object)((Object)this)));
                } else if (logger.isDebugEnabled()) {
                    logger.debug((Object)("already started " + (Object)((Object)this)));
                }
            }
        }
        finally {
            this.lifecycleLock.unlock();
        }
    }

    public final void stop() {
        this.lifecycleLock.lock();
        try {
            if (this.running) {
                this.doStop();
                this.running = false;
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("stopped " + (Object)((Object)this)));
                }
            } else if (logger.isDebugEnabled()) {
                logger.debug((Object)("already stopped " + (Object)((Object)this)));
            }
        }
        finally {
            this.lifecycleLock.unlock();
        }
    }

    public final void stop(Runnable callback) {
        this.lifecycleLock.lock();
        try {
            this.stop();
            callback.run();
        }
        finally {
            this.lifecycleLock.unlock();
        }
    }

    protected final void handleMessageInternal(Message<?> message) throws Exception {
        try {
            this.doWrite(message);
        }
        catch (Exception e) {
            throw new MessageHandlingException(message, "failed to write Message payload to GPDB/HAWQ", (Throwable)e);
        }
    }

    public void setAutoStartup(boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    public void setPhase(int phase) {
        this.phase = phase;
    }

    protected void doStart() {
    }

    protected void doStop() {
    }

    protected abstract void doWrite(Message<?> var1) throws Exception;
}

