/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.app.gemfire.sink;

import org.apache.geode.pdx.PdxInstance;
import org.springframework.cloud.stream.app.gemfire.JsonObjectTransformer;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.converter.MessageConversionException;

class GemfireSinkHandler {
    private final MessageHandler messageHandler;
    private final Boolean convertToJson;
    private final JsonObjectTransformer transformer = new JsonObjectTransformer();

    GemfireSinkHandler(MessageHandler messageHandler, Boolean convertToJson) {
        this.messageHandler = messageHandler;
        this.convertToJson = convertToJson;
    }

    public void handle(Message<?> message) {
        Message transformedMessage = message;
        if (this.convertToJson.booleanValue()) {
            Object payload = message.getPayload();
            if (payload instanceof String) {
                PdxInstance transformedPayload = this.transformer.toObject((String)payload);
                MessageBuilder.fromMessage(message);
                transformedMessage = MessageBuilder.withPayload((Object)transformedPayload).build();
            } else {
                throw new MessageConversionException(String.format("Cannot convert object of type %s", payload.getClass().getName()));
            }
        }
        this.messageHandler.handleMessage(transformedMessage);
    }
}

