/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.app.gemfire.sink;

import com.gemstone.gemfire.cache.Region;
import java.util.Collections;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.stream.annotation.EnableBinding;
import org.springframework.cloud.stream.app.gemfire.config.GemfireClientRegionConfiguration;
import org.springframework.cloud.stream.app.gemfire.config.GemfirePoolConfiguration;
import org.springframework.cloud.stream.app.gemfire.sink.GemfireSinkHandler;
import org.springframework.cloud.stream.app.gemfire.sink.GemfireSinkProperties;
import org.springframework.cloud.stream.messaging.Sink;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.integration.annotation.ServiceActivator;
import org.springframework.integration.gemfire.outbound.CacheWritingMessageHandler;
import org.springframework.messaging.MessageHandler;

@EnableBinding(value={Sink.class})
@Import(value={GemfirePoolConfiguration.class, GemfireClientRegionConfiguration.class})
@EnableConfigurationProperties(value={GemfireSinkProperties.class})
public class GemfireSinkConfiguration {
    @Autowired
    private GemfireSinkProperties config;
    @Resource(name="clientRegion")
    private Region<String, ?> region;

    @ServiceActivator(inputChannel="input")
    @Bean
    public GemfireSinkHandler gemfireSinkHandler() {
        return new GemfireSinkHandler(this.messageHandler(), this.config.isJson());
    }

    @Bean
    public MessageHandler messageHandler() {
        CacheWritingMessageHandler messageHandler = new CacheWritingMessageHandler(this.region);
        messageHandler.setCacheEntries(Collections.singletonMap(this.config.getKeyExpression(), "payload"));
        return messageHandler;
    }
}

