/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.app.file.sink;

import java.io.File;
import javax.validation.constraints.AssertTrue;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.expression.Expression;
import org.springframework.integration.file.support.FileExistsMode;
import org.springframework.util.StringUtils;

@ConfigurationProperties(value="file")
public class FileSinkProperties {
    private static final String DEFAULT_DIR = System.getProperty("java.io.tmpdir") + File.separator + "dataflow" + File.separator + "output";
    private static final String DEFAULT_NAME = "file-sink";
    private boolean binary = false;
    private String charset = "UTF-8";
    private String directory = DEFAULT_DIR;
    private Expression directoryExpression;
    private FileExistsMode mode = FileExistsMode.APPEND;
    private String name = "file-sink";
    private String nameExpression;
    private String suffix = "";

    public boolean isBinary() {
        return this.binary;
    }

    public void setBinary(boolean binary) {
        this.binary = binary;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    public Expression getDirectoryExpression() {
        return this.directoryExpression;
    }

    public void setDirectoryExpression(Expression directoryExpression) {
        this.directoryExpression = directoryExpression;
    }

    public FileExistsMode getMode() {
        return this.mode;
    }

    public void setMode(FileExistsMode mode) {
        this.mode = mode;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getNameExpression() {
        return this.nameExpression != null ? this.nameExpression + " + '" + this.getSuffix() + "'" : "'" + this.name + this.getSuffix() + "'";
    }

    public void setNameExpression(String nameExpression) {
        this.nameExpression = nameExpression;
    }

    public String getSuffix() {
        String suffixWithDotIfNecessary = "";
        if (StringUtils.hasText((String)this.suffix)) {
            suffixWithDotIfNecessary = this.suffix.startsWith(".") ? this.suffix : "." + this.suffix;
        }
        return suffixWithDotIfNecessary;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    @AssertTrue(message="Exactly one of 'name' or 'nameExpression' must be set")
    public boolean isMutuallyExclusiveNameAndNameExpression() {
        return DEFAULT_NAME.equals(this.name) || this.nameExpression == null;
    }

    @AssertTrue(message="Exactly one of 'directory' or 'directoryExpression' must be set")
    public boolean isMutuallyExclusiveDirectoryAndDirectoryExpression() {
        return DEFAULT_DIR.equals(this.directory) || this.directoryExpression == null;
    }
}

