/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.app.file.sink;

import java.io.File;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.stream.annotation.EnableBinding;
import org.springframework.cloud.stream.app.file.sink.FileSinkProperties;
import org.springframework.cloud.stream.messaging.Sink;
import org.springframework.context.annotation.Bean;
import org.springframework.integration.annotation.ServiceActivator;
import org.springframework.integration.file.DefaultFileNameGenerator;
import org.springframework.integration.file.FileNameGenerator;
import org.springframework.integration.file.FileWritingMessageHandler;

@EnableBinding(value={Sink.class})
@EnableConfigurationProperties(value={FileSinkProperties.class})
public class FileSinkConfiguration {
    @Bean
    @ServiceActivator(inputChannel="input")
    public FileWritingMessageHandler fileWritingMessageHandler(FileNameGenerator fileNameGenerator, FileSinkProperties properties) {
        FileWritingMessageHandler handler = properties.getDirectoryExpression() != null ? new FileWritingMessageHandler(properties.getDirectoryExpression()) : new FileWritingMessageHandler(new File(properties.getDirectory()));
        handler.setAutoCreateDirectory(true);
        handler.setAppendNewLine(!properties.isBinary());
        handler.setCharset(properties.getCharset());
        handler.setExpectReply(false);
        handler.setFileExistsMode(properties.getMode());
        handler.setFileNameGenerator(fileNameGenerator);
        return handler;
    }

    @Bean
    public FileNameGenerator fileNameGenerator(FileSinkProperties properties) {
        DefaultFileNameGenerator fileNameGenerator = new DefaultFileNameGenerator();
        fileNameGenerator.setExpression(properties.getNameExpression());
        return fileNameGenerator;
    }
}

