/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.app.field.value.counter.sink;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.analytics.metrics.FieldValueCounterWriter;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.stream.annotation.EnableBinding;
import org.springframework.cloud.stream.app.field.value.counter.sink.FieldValueCounterSinkProperties;
import org.springframework.cloud.stream.app.field.value.counter.sink.FieldValueCounterSinkStoreConfiguration;
import org.springframework.cloud.stream.messaging.Sink;
import org.springframework.context.annotation.Import;
import org.springframework.integration.annotation.ServiceActivator;
import org.springframework.integration.transformer.MessageTransformationException;
import org.springframework.integration.tuple.JsonToTupleTransformer;
import org.springframework.messaging.Message;
import org.springframework.tuple.Tuple;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@EnableBinding(value={Sink.class})
@Import(value={FieldValueCounterSinkStoreConfiguration.class})
public class FieldValueCounterSinkConfiguration {
    private static final Log log = LogFactory.getLog(FieldValueCounterSinkConfiguration.class);
    @Autowired
    private FieldValueCounterSinkProperties fvcSinkProperties;
    @Autowired
    private FieldValueCounterWriter fieldValueCounterWriter;
    private final JsonToTupleTransformer jsonToTupleTransformer = new JsonToTupleTransformer();

    @ServiceActivator(inputChannel="input")
    public void process(Message<?> message) {
        Object payload = message.getPayload();
        if (payload instanceof String) {
            try {
                payload = this.jsonToTupleTransformer.transformPayload(payload.toString());
            }
            catch (Exception e) {
                throw new MessageTransformationException(message, e.getMessage(), (Throwable)e);
            }
        }
        if (payload instanceof Tuple) {
            this.processTuple(this.computeMetricName(message), (Tuple)payload);
        } else {
            this.processPojo(this.computeMetricName(message), payload);
        }
    }

    private void processPojo(String counterName, Object payload) {
        String fieldName = this.fvcSinkProperties.getFieldName();
        Object value = null;
        if (payload instanceof Map) {
            Map map = (Map)payload;
            if (map.containsKey(fieldName)) {
                value = map.get(fieldName);
            } else {
                log.error((Object)("The property '" + fieldName + "' is not available in the payload: " + payload));
            }
        } else {
            BeanWrapperImpl beanWrapper = new BeanWrapperImpl(payload);
            if (beanWrapper.isReadableProperty(fieldName)) {
                value = beanWrapper.getPropertyValue(fieldName);
            } else {
                log.error((Object)("The property '" + fieldName + "' is not available in the payload: " + payload));
            }
        }
        if (value != null) {
            this.processValue(counterName, value);
        } else {
            log.info((Object)("The value for the property '" + fieldName + "' in the payload '" + payload + "' is null. Ignored"));
        }
    }

    private void processTuple(String counterName, Tuple tuple) {
        String[] path = StringUtils.tokenizeToStringArray((String)this.fvcSinkProperties.getFieldName(), (String)".");
        this.processValueForCounter(counterName, tuple, path);
    }

    private void processValueForCounter(String counterName, Object value, String[] path) {
        String key = path[0];
        Object result = null;
        if (value instanceof List) {
            for (Object item : (List)value) {
                this.processValueForCounter(counterName, item, path);
            }
        } else if (value instanceof Tuple) {
            Tuple t = (Tuple)value;
            if (t.hasFieldName(key)) {
                result = t.getValue(key);
            }
        } else if (value instanceof Map) {
            result = ((Map)value).get(key);
        }
        if (result != null) {
            if (path.length == 1) {
                this.processValue(counterName, result);
            } else {
                path = Arrays.copyOfRange(path, 1, path.length);
                this.processValueForCounter(counterName, result, path);
            }
        } else {
            log.info((Object)("The value for the property '" + Arrays.toString(path) + "' in the payload '" + value + "' is null. Ignored"));
        }
    }

    protected void processValue(String counterName, Object value) {
        if (value instanceof Collection || ObjectUtils.isArray((Object)value)) {
            List<Object> c = value instanceof Collection ? (List<Object>)value : Arrays.asList(ObjectUtils.toObjectArray((Object)value));
            for (Object e : c) {
                this.fieldValueCounterWriter.increment(counterName, e.toString(), 1.0);
            }
        } else {
            this.fieldValueCounterWriter.increment(counterName, value.toString(), 1.0);
        }
    }

    protected String computeMetricName(Message<?> message) {
        return ((CharSequence)this.fvcSinkProperties.getComputedNameExpression().getValue(message, CharSequence.class)).toString();
    }
}

