/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.app.field.value.counter.sink;

import java.util.Collections;
import org.springframework.analytics.metrics.FieldValueCounterRepository;
import org.springframework.analytics.metrics.redis.RedisFieldValueCounterRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.stream.app.field.value.counter.sink.FieldValueCounterSinkProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.RedisConnectionFailureException;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.retry.RetryOperations;
import org.springframework.retry.RetryPolicy;
import org.springframework.retry.backoff.BackOffPolicy;
import org.springframework.retry.backoff.ExponentialBackOffPolicy;
import org.springframework.retry.policy.SimpleRetryPolicy;
import org.springframework.retry.support.RetryTemplate;

@Configuration
@EnableConfigurationProperties(value={FieldValueCounterSinkProperties.class})
public class FieldValueCounterSinkStoreConfiguration {
    @Autowired
    private RedisConnectionFactory redisConnectionFactory;
    @Autowired
    private FieldValueCounterSinkProperties config;

    @Bean
    public FieldValueCounterRepository redisMetricRepository() {
        return new RedisFieldValueCounterRepository(this.redisConnectionFactory, this.retryOperations());
    }

    @Bean
    public RetryOperations retryOperations() {
        RetryTemplate retryTemplate = new RetryTemplate();
        retryTemplate.setRetryPolicy((RetryPolicy)new SimpleRetryPolicy(3, Collections.singletonMap(RedisConnectionFailureException.class, true)));
        ExponentialBackOffPolicy backOffPolicy = new ExponentialBackOffPolicy();
        backOffPolicy.setInitialInterval(1000L);
        backOffPolicy.setMaxInterval(1000L);
        backOffPolicy.setMultiplier(2.0);
        retryTemplate.setBackOffPolicy((BackOffPolicy)backOffPolicy);
        return retryTemplate;
    }
}

