/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.app.counter.sink;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.stream.annotation.EnableBinding;
import org.springframework.cloud.stream.app.analytics.common.CounterCommonConfiguration;
import org.springframework.cloud.stream.app.analytics.common.CounterService;
import org.springframework.cloud.stream.app.counter.sink.CounterSinkProperties;
import org.springframework.cloud.stream.messaging.Sink;
import org.springframework.context.annotation.Import;
import org.springframework.integration.annotation.ServiceActivator;
import org.springframework.messaging.Message;

@EnableBinding(value={Sink.class})
@EnableConfigurationProperties(value={CounterSinkProperties.class})
@Import(value={CounterCommonConfiguration.class})
public class CounterSinkConfiguration {
    private static final Log logger = LogFactory.getLog(CounterSinkConfiguration.class);
    @Autowired
    private CounterService counterService;

    @ServiceActivator(inputChannel="input")
    public void count(Message<?> message) {
        this.counterService.count(message);
    }
}

