/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.app.counter.sink;

import javax.validation.constraints.AssertTrue;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.expression.Expression;
import org.springframework.expression.common.LiteralExpression;
import org.springframework.validation.annotation.Validated;

@ConfigurationProperties(value="counter")
@Validated
public class CounterProperties {
    @Value(value="${spring.application.name:counts}")
    private String defaultName;
    private String name;
    private Expression nameExpression;

    public String getName() {
        if (this.name == null && this.nameExpression == null) {
            return this.defaultName;
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Expression getNameExpression() {
        return this.nameExpression;
    }

    public Expression getComputedNameExpression() {
        return this.nameExpression != null ? this.nameExpression : new LiteralExpression(this.getName());
    }

    public void setNameExpression(Expression nameExpression) {
        this.nameExpression = nameExpression;
    }

    @AssertTrue(message="exactly one of 'name' and 'nameExpression' must be set")
    public boolean isExclusiveOptions() {
        return this.getName() != null ^ this.getNameExpression() != null;
    }
}

