/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.app.cassandra;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.RemoteEndpointAwareJdkSSLOptions;
import com.datastax.driver.core.SSLOptions;
import com.datastax.driver.core.Session;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Scanner;
import javax.annotation.PostConstruct;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.autoconfigure.cassandra.CassandraProperties;
import org.springframework.boot.autoconfigure.cassandra.ClusterBuilderCustomizer;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.domain.EntityScanPackages;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.cloud.stream.app.cassandra.CassandraClusterProperties;
import org.springframework.cloud.stream.app.cassandra.util.TrustAllSSLContextFactory;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.data.cassandra.core.ReactiveCassandraTemplate;
import org.springframework.data.cassandra.core.cql.CqlTemplate;
import org.springframework.data.cassandra.core.cql.ReactiveCqlOperations;
import org.springframework.data.cassandra.core.cql.generator.CreateKeyspaceCqlGenerator;
import org.springframework.data.cassandra.core.cql.keyspace.CreateKeyspaceSpecification;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;

@Configuration
@EnableConfigurationProperties(value={CassandraClusterProperties.class})
@Import(value={CassandraPackageRegistrar.class})
public class CassandraAppClusterConfiguration {
    @Bean
    @ConditionalOnProperty(prefix="cassandra.cluster", name={"createKeyspace"})
    public static BeanPostProcessor createKeySpacePostProcessor(final CassandraProperties cassandraProperties) {
        return new BeanPostProcessor(){

            public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
                if (bean instanceof Cluster) {
                    CreateKeyspaceSpecification createKeyspaceSpecification = CreateKeyspaceSpecification.createKeyspace((String)cassandraProperties.getKeyspaceName()).withSimpleReplication().ifNotExists();
                    String createKeySpaceQuery = new CreateKeyspaceCqlGenerator(createKeyspaceSpecification).toCql();
                    try (Session session = ((Cluster)bean).connect();){
                        CqlTemplate template = new CqlTemplate(session);
                        template.execute(createKeySpaceQuery);
                    }
                }
                return bean;
            }
        };
    }

    @Bean
    public ClusterBuilderCustomizer clusterBuilderCustomizer(CassandraClusterProperties cassandraClusterProperties) {
        PropertyMapper map = PropertyMapper.get();
        return builder -> {
            map.from(cassandraClusterProperties::isMetricsEnabled).whenFalse().toCall(() -> ((Cluster.Builder)builder).withoutMetrics());
            map.from(cassandraClusterProperties::isSkipSslValidation).whenTrue().toCall(() -> {
                RemoteEndpointAwareJdkSSLOptions.Builder optsBuilder = RemoteEndpointAwareJdkSSLOptions.builder();
                try {
                    optsBuilder.withSSLContext(TrustAllSSLContextFactory.getSslContext());
                }
                catch (KeyManagementException | NoSuchAlgorithmException e) {
                    throw new BeanInitializationException("Unable to configure a Cassandra cluster using SSL.", (Throwable)e);
                }
                builder.withSSL((SSLOptions)optsBuilder.build());
            });
        };
    }

    @Configuration
    protected static class CassandraKeyspaceInitializerConfiguration {
        @Autowired
        private CassandraClusterProperties cassandraClusterProperties;
        @Autowired
        private ReactiveCassandraTemplate reactiveCassandraTemplate;

        protected CassandraKeyspaceInitializerConfiguration() {
        }

        @PostConstruct
        public void init() throws IOException {
            if (this.cassandraClusterProperties.getInitScript() != null) {
                String scripts = new Scanner(this.cassandraClusterProperties.getInitScript().getInputStream(), "UTF-8").useDelimiter("\\A").next();
                ReactiveCqlOperations reactiveCqlOperations = this.reactiveCassandraTemplate.getReactiveCqlOperations();
                Flux.fromArray((Object[])StringUtils.delimitedListToStringArray((String)scripts, (String)";", (String)"\r\n\f")).filter(StringUtils::hasText).flatMap(script -> reactiveCqlOperations.execute(script + ";")).blockLast();
            }
        }
    }

    static class CassandraPackageRegistrar
    implements ImportBeanDefinitionRegistrar,
    EnvironmentAware {
        private Environment environment;

        CassandraPackageRegistrar() {
        }

        public void setEnvironment(Environment environment) {
            this.environment = environment;
        }

        public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
            Binder.get((Environment)this.environment).bind("cassandra.cluster.entity-base-packages", String[].class).map(Arrays::asList).ifBound(packagesToScan -> EntityScanPackages.register((BeanDefinitionRegistry)registry, (Collection)packagesToScan));
        }
    }
}

