/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.app.cassandra.sink;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.util.StdDateFormat;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cassandra.core.WriteOptions;
import org.springframework.cloud.stream.annotation.EnableBinding;
import org.springframework.cloud.stream.app.cassandra.CassandraConfiguration;
import org.springframework.cloud.stream.app.cassandra.query.ColumnNameExtractor;
import org.springframework.cloud.stream.app.cassandra.query.InsertQueryColumnNameExtractor;
import org.springframework.cloud.stream.app.cassandra.query.UpdateQueryColumnNameExtractor;
import org.springframework.cloud.stream.app.cassandra.sink.CassandraSinkProperties;
import org.springframework.cloud.stream.messaging.Sink;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.PropertySource;
import org.springframework.data.cassandra.core.CassandraOperations;
import org.springframework.integration.annotation.ServiceActivator;
import org.springframework.integration.cassandra.outbound.CassandraMessageHandler;
import org.springframework.integration.channel.DirectChannel;
import org.springframework.integration.handler.BridgeHandler;
import org.springframework.integration.support.json.Jackson2JsonObjectMapper;
import org.springframework.integration.support.json.JsonObjectMapper;
import org.springframework.integration.transformer.AbstractPayloadTransformer;
import org.springframework.integration.transformer.MessageTransformingHandler;
import org.springframework.integration.transformer.Transformer;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandler;
import org.springframework.util.StringUtils;

@EnableBinding(value={Sink.class})
@Import(value={CassandraConfiguration.class})
@EnableConfigurationProperties(value={CassandraSinkProperties.class})
@PropertySource(value={"cassandra-application.properties"})
public class CassandraSinkConfiguration {
    @Autowired
    private CassandraSinkProperties cassandraSinkProperties;
    @Autowired
    private CassandraOperations template;

    @Bean
    public MessageChannel toSink() {
        return new DirectChannel();
    }

    @Bean
    @Primary
    @ServiceActivator(inputChannel="input")
    public MessageHandler bridgeMessageHandler() {
        Object messageHandler = StringUtils.hasText((String)this.cassandraSinkProperties.getIngestQuery()) ? new MessageTransformingHandler((Transformer)new PayloadToMatrixTransformer(this.cassandraSinkProperties.getIngestQuery(), CassandraMessageHandler.Type.UPDATE == this.cassandraSinkProperties.getQueryType() ? new UpdateQueryColumnNameExtractor() : new InsertQueryColumnNameExtractor())) : new BridgeHandler();
        messageHandler.setOutputChannel(this.toSink());
        return messageHandler;
    }

    @Bean
    @ServiceActivator(inputChannel="toSink")
    public MessageHandler cassandraSinkMessageHandler() {
        CassandraMessageHandler cassandraMessageHandler = this.cassandraSinkProperties.getQueryType() != null ? new CassandraMessageHandler(this.template, this.cassandraSinkProperties.getQueryType()) : new CassandraMessageHandler(this.template);
        cassandraMessageHandler.setProducesReply(false);
        if (this.cassandraSinkProperties.getConsistencyLevel() != null || this.cassandraSinkProperties.getRetryPolicy() != null || this.cassandraSinkProperties.getTtl() > 0) {
            cassandraMessageHandler.setWriteOptions(new WriteOptions(this.cassandraSinkProperties.getConsistencyLevel(), this.cassandraSinkProperties.getRetryPolicy(), Integer.valueOf(this.cassandraSinkProperties.getTtl())));
        }
        if (StringUtils.hasText((String)this.cassandraSinkProperties.getIngestQuery())) {
            cassandraMessageHandler.setIngestQuery(this.cassandraSinkProperties.getIngestQuery());
        } else if (this.cassandraSinkProperties.getStatementExpression() != null) {
            cassandraMessageHandler.setStatementExpression(this.cassandraSinkProperties.getStatementExpression());
        }
        return cassandraMessageHandler;
    }

    private static boolean isUuid(String uuid) {
        String[] parts;
        return uuid.length() == 36 && (parts = uuid.split("-")).length == 5 && parts[0].length() == 8 && parts[1].length() == 4 && parts[2].length() == 4 && parts[3].length() == 4 && parts[4].length() == 12;
    }

    private static class ISO8601StdDateFormat
    extends StdDateFormat {
        private ISO8601StdDateFormat() {
        }

        protected boolean looksLikeISO8601(String dateStr) {
            return super.looksLikeISO8601(dateStr);
        }
    }

    private static class PayloadToMatrixTransformer
    extends AbstractPayloadTransformer<Object, List<List<Object>>> {
        private final ObjectMapper objectMapper = new ObjectMapper();
        private final JsonObjectMapper<?, ?> jsonObjectMapper = new Jackson2JsonObjectMapper(this.objectMapper);
        private final List<String> columns = new LinkedList<String>();
        private final ISO8601StdDateFormat dateFormat = new ISO8601StdDateFormat();

        public PayloadToMatrixTransformer(String query, ColumnNameExtractor columnNameExtractor) {
            this.columns.addAll(columnNameExtractor.extract(query));
            this.objectMapper.configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected List<List<Object>> transformPayload(Object payload) throws Exception {
            if (payload instanceof List) {
                return (List)payload;
            }
            List model = (List)this.jsonObjectMapper.fromJson(payload, List.class);
            ArrayList<List<Object>> data = new ArrayList<List<Object>>(model.size());
            for (Map entity : model) {
                ArrayList row = new ArrayList(this.columns.size());
                for (String column : this.columns) {
                    Object value = entity.get(column);
                    if (value instanceof String) {
                        String string = (String)value;
                        if (this.dateFormat.looksLikeISO8601(string)) {
                            ISO8601StdDateFormat iSO8601StdDateFormat = this.dateFormat;
                            synchronized (iSO8601StdDateFormat) {
                                value = this.dateFormat.parse(string);
                            }
                        }
                        if (CassandraSinkConfiguration.isUuid(string)) {
                            value = UUID.fromString(string);
                        }
                    }
                    row.add(value);
                }
                data.add(row);
            }
            return data;
        }
    }
}

