/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.app.aggregate.counter.sink;

import java.util.Collections;
import org.springframework.analytics.metrics.AggregateCounterRepository;
import org.springframework.analytics.metrics.redis.RedisAggregateCounterRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.stream.app.aggregate.counter.sink.AggregateCounterSinkProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.RedisConnectionFailureException;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.retry.RetryOperations;
import org.springframework.retry.RetryPolicy;
import org.springframework.retry.backoff.BackOffPolicy;
import org.springframework.retry.backoff.ExponentialBackOffPolicy;
import org.springframework.retry.policy.SimpleRetryPolicy;
import org.springframework.retry.support.RetryTemplate;

@Configuration
@EnableConfigurationProperties(value={AggregateCounterSinkProperties.class})
public class AggregateCounterSinkStoreConfiguration {
    @Autowired
    private RedisConnectionFactory redisConnectionFactory;
    @Autowired
    private AggregateCounterSinkProperties config;

    @Bean
    public AggregateCounterRepository aggregateCounterRepository() {
        return new RedisAggregateCounterRepository(this.redisConnectionFactory, this.retryOperations());
    }

    @Bean
    public RetryOperations retryOperations() {
        RetryTemplate retryTemplate = new RetryTemplate();
        retryTemplate.setRetryPolicy((RetryPolicy)new SimpleRetryPolicy(3, Collections.singletonMap(RedisConnectionFailureException.class, true)));
        ExponentialBackOffPolicy backOffPolicy = new ExponentialBackOffPolicy();
        backOffPolicy.setInitialInterval(1000L);
        backOffPolicy.setMaxInterval(1000L);
        backOffPolicy.setMultiplier(2.0);
        retryTemplate.setBackOffPolicy((BackOffPolicy)backOffPolicy);
        return retryTemplate;
    }
}

