/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.app.aggregate.counter.sink;

import javax.validation.constraints.AssertTrue;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.NotBlank;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.stream.app.time.DateFormat;
import org.springframework.expression.Expression;
import org.springframework.expression.common.LiteralExpression;
import org.springframework.integration.expression.ValueExpression;
import org.springframework.validation.annotation.Validated;

@ConfigurationProperties(value="aggregate-counter")
@Validated
public class AggregateCounterSinkProperties {
    @Value(value="${spring.application.name:aggregate-counter}")
    private String defaultName;
    private String name;
    private Expression nameExpression;
    private Expression timeField;
    private Expression incrementExpression = new ValueExpression((Object)1L);
    private String dateFormat = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";

    public String getName() {
        if (this.name == null && this.nameExpression == null) {
            return this.defaultName;
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Expression getNameExpression() {
        return this.nameExpression;
    }

    public Expression getComputedNameExpression() {
        return this.nameExpression != null ? this.nameExpression : new LiteralExpression(this.getName());
    }

    public void setNameExpression(Expression nameExpression) {
        this.nameExpression = nameExpression;
    }

    @AssertTrue(message="exactly one of 'name' and 'nameExpression' must be set")
    public boolean isExclusiveOptions() {
        return this.getName() != null ^ this.getNameExpression() != null;
    }

    public Expression getTimeField() {
        return this.timeField;
    }

    public void setTimeField(Expression timeField) {
        this.timeField = timeField;
    }

    public Expression getIncrementExpression() {
        return this.incrementExpression;
    }

    public void setIncrementExpression(Expression incrementExpression) {
        this.incrementExpression = incrementExpression;
    }

    @NotBlank
    @DateFormat
    public String getDateFormat() {
        return this.dateFormat;
    }

    @NotNull
    public DateTimeFormatter getDateFormatter() {
        return DateTimeFormat.forPattern((String)this.getDateFormat());
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }
}

