/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.app.aggregate.counter.sink;

import org.joda.time.DateTime;
import org.springframework.analytics.metrics.AggregateCounterRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.stream.annotation.EnableBinding;
import org.springframework.cloud.stream.app.aggregate.counter.sink.AggregateCounterSinkProperties;
import org.springframework.cloud.stream.app.aggregate.counter.sink.AggregateCounterSinkStoreConfiguration;
import org.springframework.cloud.stream.messaging.Sink;
import org.springframework.context.annotation.Import;
import org.springframework.integration.annotation.ServiceActivator;
import org.springframework.messaging.Message;

@EnableBinding(value={Sink.class})
@EnableConfigurationProperties(value={AggregateCounterSinkProperties.class})
@Import(value={AggregateCounterSinkStoreConfiguration.class})
public class AggregateCounterSinkConfiguration {
    @Autowired
    private AggregateCounterSinkProperties config;
    @Autowired
    private AggregateCounterRepository aggregateCounterRepository;

    @ServiceActivator(inputChannel="input")
    public void process(Message<?> message) {
        Long increment = (Long)this.config.getIncrementExpression().getValue(message, Long.class);
        String counterName = (String)this.config.getComputedNameExpression().getValue(message, String.class);
        if (this.config.getTimeField() == null) {
            this.aggregateCounterRepository.increment(counterName, increment.longValue(), DateTime.now());
        } else {
            String timeStampValue = (String)this.config.getTimeField().getValue(message, String.class);
            this.aggregateCounterRepository.increment(counterName, increment.longValue(), this.config.getDateFormatter().parseDateTime(timeStampValue));
        }
    }
}

