/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.app.gemfire.config;

import javax.validation.constraints.AssertTrue;
import javax.validation.constraints.NotBlank;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.core.io.Resource;
import org.springframework.validation.annotation.Validated;

@ConfigurationProperties(value="gemfire.security.ssl")
@Validated
public class GemfireSslProperties {
    private static final String USER_HOME_DIRECTORY = System.getProperty("user.home");
    public static final String LOCAL_TRUSTSTORE_FILE_NAME = "trusted.keystore";
    public static final String LOCAL_KEYSTORE_FILE_NAME = "keystore.keystore";
    @NotBlank
    private String userHomeDirectory = USER_HOME_DIRECTORY;
    private Resource truststoreUri;
    private String sslTruststorePassword;
    @NotBlank
    private String truststoreType = "JKS";
    private Resource keystoreUri;
    private String sslKeystorePassword;
    @NotBlank
    private String keystoreType = "JKS";
    @NotBlank
    private String ciphers = "any";

    public Resource getTruststoreUri() {
        return this.truststoreUri;
    }

    public void setTruststoreUri(Resource truststoreUri) {
        this.truststoreUri = truststoreUri;
    }

    public String getSslKeystorePassword() {
        return this.sslKeystorePassword;
    }

    public void setSslKeystorePassword(String sslKeystorePassword) {
        this.sslKeystorePassword = sslKeystorePassword;
    }

    public String getSslTruststorePassword() {
        return this.sslTruststorePassword;
    }

    public void setSslTruststorePassword(String sslTruststorePassword) {
        this.sslTruststorePassword = sslTruststorePassword;
    }

    public String getUserHomeDirectory() {
        return this.userHomeDirectory;
    }

    public void setUserHomeDirectory(String userHomeDirectory) {
        this.userHomeDirectory = userHomeDirectory;
    }

    public String getTruststoreType() {
        return this.truststoreType;
    }

    public void setTruststoreType(String truststoreType) {
        this.truststoreType = truststoreType;
    }

    public Resource getKeystoreUri() {
        return this.keystoreUri;
    }

    public void setKeystoreUri(Resource keystoreUri) {
        this.keystoreUri = keystoreUri;
    }

    public String getKeystoreType() {
        return this.keystoreType;
    }

    public void setKeystoreType(String keystoreType) {
        this.keystoreType = keystoreType;
    }

    public String getCiphers() {
        return this.ciphers;
    }

    public void setCiphers(String ciphers) {
        this.ciphers = ciphers;
    }

    public boolean isSslEnabled() {
        return this.truststoreUri != null && this.keystoreUri != null;
    }

    @AssertTrue(message="The truststoreUri and keystoreUri should together be either empty or not!")
    private @AssertTrue(message="The truststoreUri and keystoreUri should together be either empty or not!") boolean isStoreUrisConsistent() {
        return this.truststoreUri == null && this.keystoreUri == null || this.truststoreUri != null && this.keystoreUri != null;
    }

    @AssertTrue(message="The sslKeystorePassword and sslKeystorePassword must not be empty for non empty store URIs!")
    private @AssertTrue(message="The sslKeystorePassword and sslKeystorePassword must not be empty for non empty store URIs!") boolean isStorePasswordRequiredForValidStoreUri() {
        return !this.isSslEnabled() || this.sslKeystorePassword != null && this.sslTruststorePassword != null;
    }
}

