/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.app.gemfire.config;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import org.apache.geode.pdx.PdxSerializer;
import org.apache.geode.pdx.ReflectionBasedAutoSerializer;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.stream.app.gemfire.config.GemfireClientCacheProperties;
import org.springframework.cloud.stream.app.gemfire.config.GemfireSecurityProperties;
import org.springframework.cloud.stream.app.gemfire.config.GemfireSslProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.core.io.Resource;
import org.springframework.data.gemfire.client.ClientCacheFactoryBean;
import org.springframework.data.gemfire.util.PropertiesBuilder;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.StringUtils;

@EnableConfigurationProperties(value={GemfireClientCacheProperties.class, GemfireSecurityProperties.class, GemfireSslProperties.class})
public class GemfireClientCacheConfiguration {
    private static final String SECURITY_CLIENT = "security-client-auth-init";
    private static final String SECURITY_USERNAME = "security-username";
    private static final String SECURITY_PASSWORD = "security-password";

    @Bean
    public ClientCacheFactoryBean clientCache(GemfireClientCacheProperties clientCacheProperties, GemfireSecurityProperties securityProperties, GemfireSslProperties sslProperties) {
        ClientCacheFactoryBean clientCacheFactoryBean = new ClientCacheFactoryBean();
        clientCacheFactoryBean.setUseBeanFactoryLocator(false);
        clientCacheFactoryBean.setPoolName("gemfirePool");
        if (StringUtils.hasText((String)securityProperties.getUsername()) && StringUtils.hasText((String)securityProperties.getPassword())) {
            Properties properties = new Properties();
            properties.setProperty(SECURITY_CLIENT, GemfireSecurityProperties.UserAuthInitialize.class.getName() + ".create");
            properties.setProperty(SECURITY_USERNAME, securityProperties.getUsername());
            properties.setProperty(SECURITY_PASSWORD, securityProperties.getPassword());
            clientCacheFactoryBean.setProperties(properties);
        }
        if (sslProperties.isSslEnabled()) {
            PropertiesBuilder pb = new PropertiesBuilder();
            pb.add(clientCacheFactoryBean.getProperties());
            pb.add(this.toGeodeSslProperties(sslProperties));
            clientCacheFactoryBean.setProperties(pb.build());
        }
        clientCacheFactoryBean.setReadyForEvents(Boolean.valueOf(true));
        if (clientCacheProperties.isPdxReadSerialized()) {
            clientCacheFactoryBean.setPdxSerializer((PdxSerializer)new ReflectionBasedAutoSerializer(new String[]{".*"}));
            clientCacheFactoryBean.setPdxReadSerialized(Boolean.valueOf(true));
        }
        return clientCacheFactoryBean;
    }

    private Properties toGeodeSslProperties(GemfireSslProperties sslProperties) {
        PropertiesBuilder pb = new PropertiesBuilder();
        pb.setProperty("ssl-enabled-components", "server,locator");
        pb.setProperty("ssl-keystore", this.resolveRemoteStore(sslProperties.getKeystoreUri(), sslProperties.getUserHomeDirectory(), "keystore.keystore"));
        pb.setProperty("ssl-keystore-password", sslProperties.getSslKeystorePassword());
        pb.setProperty("ssl-keystore-type", sslProperties.getKeystoreType());
        pb.setProperty("ssl-truststore", this.resolveRemoteStore(sslProperties.getTruststoreUri(), sslProperties.getUserHomeDirectory(), "trusted.keystore"));
        pb.setProperty("ssl-truststore-password", sslProperties.getSslTruststorePassword());
        pb.setProperty("ssl-truststore-type", sslProperties.getTruststoreType());
        pb.setProperty("ssl-ciphers", sslProperties.getCiphers());
        return pb.build();
    }

    private String resolveRemoteStore(Resource storeUri, String userHomeDirectory, String localStoreFileName) {
        File localStoreFile = new File(userHomeDirectory, localStoreFileName);
        try {
            FileCopyUtils.copy((InputStream)storeUri.getInputStream(), (OutputStream)new FileOutputStream(localStoreFile));
            return localStoreFile.getAbsolutePath();
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format("Failed to copy the store from [%s] into %s", storeUri.getDescription(), localStoreFile.getAbsolutePath()), e);
        }
    }
}

