/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.app.gemfire;

import org.apache.geode.pdx.JSONFormatter;
import org.apache.geode.pdx.PdxInstance;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.integration.transformer.MessageTransformationException;

public class JsonObjectTransformer {
    public PdxInstance toObject(String json) {
        JSONObject jsonObject = null;
        try {
            jsonObject = new JSONObject(json);
        }
        catch (JSONException e) {
            throw new MessageTransformationException(e.getMessage());
        }
        return JSONFormatter.fromJSON((String)jsonObject.toString());
    }

    public String toString(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof PdxInstance) {
            String json = JSONFormatter.toJSON((PdxInstance)((PdxInstance)obj));
            return json.replaceAll("\\r\\n\\s*", "").replaceAll("\\n\\s*", "").replaceAll("\\s*:\\s*", ":").trim();
        }
        return obj.toString();
    }
}

