/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.app.gemfire.config;

import java.util.Properties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.stream.app.gemfire.config.GemfireSecurityProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.data.gemfire.client.ClientCacheFactoryBean;
import org.springframework.util.StringUtils;

@EnableConfigurationProperties(value={GemfireSecurityProperties.class})
public class GemfireClientCacheConfiguration {
    private static final String SECURITY_CLIENT = "security-client-auth-init";
    private static final String SECURITY_USERNAME = "security-username";
    private static final String SECURITY_PASSWORD = "security-password";

    @Bean
    public ClientCacheFactoryBean clientCache(GemfireSecurityProperties securityProperties) {
        ClientCacheFactoryBean clientCacheFactoryBean = new ClientCacheFactoryBean();
        clientCacheFactoryBean.setUseBeanFactoryLocator(false);
        clientCacheFactoryBean.setPoolName("gemfirePool");
        if (StringUtils.hasText((String)securityProperties.getUsername()) && StringUtils.hasText((String)securityProperties.getPassword())) {
            Properties properties = new Properties();
            properties.setProperty(SECURITY_CLIENT, GemfireSecurityProperties.UserAuthInitialize.class.getName() + ".create");
            properties.setProperty(SECURITY_USERNAME, securityProperties.getUsername());
            properties.setProperty(SECURITY_PASSWORD, securityProperties.getPassword());
            clientCacheFactoryBean.setProperties(properties);
        }
        clientCacheFactoryBean.setReadyForEvents(Boolean.valueOf(true));
        return clientCacheFactoryBean;
    }
}

