/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.app.gemfire.config;

import java.util.Arrays;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.stream.app.gemfire.config.GemfirePoolProperties;
import org.springframework.cloud.stream.app.gemfire.config.InetSocketAddressConverterConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.data.gemfire.client.PoolFactoryBean;
import org.springframework.data.gemfire.support.ConnectionEndpointList;

@Configuration
@EnableConfigurationProperties(value={GemfirePoolProperties.class})
@Import(value={InetSocketAddressConverterConfiguration.class})
public class GemfirePoolConfiguration {
    @Autowired
    private GemfirePoolProperties config;

    @Bean
    public PoolFactoryBean gemfirePool() {
        PoolFactoryBean poolFactoryBean = new PoolFactoryBean();
        ConnectionEndpointList endpointList = ConnectionEndpointList.from(Arrays.asList(this.config.getHostAddresses()));
        switch (this.config.getConnectType()) {
            case locator: {
                poolFactoryBean.setLocatorEndpointList(endpointList);
                break;
            }
            case server: {
                poolFactoryBean.setServerEndpointList(endpointList);
                break;
            }
            default: {
                throw new IllegalArgumentException("connectType " + (Object)((Object)this.config.getConnectType()) + " is not supported.");
            }
        }
        poolFactoryBean.setSubscriptionEnabled(this.config.isSubscriptionEnabled());
        poolFactoryBean.setName("gemfirePool");
        return poolFactoryBean;
    }
}

