/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.app.gemfire.config;

import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.GemFireCache;
import java.util.List;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.stream.app.gemfire.config.GemfireClientCacheConfiguration;
import org.springframework.cloud.stream.app.gemfire.config.GemfireRegionProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.data.gemfire.client.ClientCacheFactoryBean;
import org.springframework.data.gemfire.client.ClientRegionFactoryBean;
import org.springframework.data.gemfire.client.Interest;
import org.springframework.util.CollectionUtils;

@Configuration
@Import(value={GemfireClientCacheConfiguration.class})
@EnableConfigurationProperties(value={GemfireRegionProperties.class})
public class GemfireClientRegionConfiguration {
    @Autowired
    private GemfireRegionProperties config;
    @Autowired
    private ClientCacheFactoryBean clientCache;
    @Autowired(required=false)
    private List<Interest> keyInterests;

    @Bean(name={"clientRegion"})
    public ClientRegionFactoryBean clientRegionFactoryBean() {
        ClientRegionFactoryBean clientRegionFactoryBean = new ClientRegionFactoryBean();
        clientRegionFactoryBean.setRegionName(this.config.getRegionName());
        clientRegionFactoryBean.setDataPolicy(DataPolicy.EMPTY);
        if (!CollectionUtils.isEmpty(this.keyInterests)) {
            clientRegionFactoryBean.setInterests(this.keyInterests.toArray(new Interest[this.keyInterests.size()]));
        }
        try {
            clientRegionFactoryBean.setCache((GemFireCache)this.clientCache.getObject());
        }
        catch (Exception e) {
            throw new BeanCreationException(e.getMessage(), (Throwable)e);
        }
        return clientRegionFactoryBean;
    }
}

