/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.app.mqtt;

import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;
import org.eclipse.paho.client.mqttv3.persist.MqttDefaultFilePersistence;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.stream.app.mqtt.MqttProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.integration.mqtt.core.DefaultMqttPahoClientFactory;
import org.springframework.integration.mqtt.core.MqttPahoClientFactory;
import org.springframework.util.ObjectUtils;

@Configuration
public class MqttConfiguration {
    @Autowired
    private MqttProperties mqttProperties;

    @Bean
    public MqttPahoClientFactory mqttClientFactory() {
        DefaultMqttPahoClientFactory factory = new DefaultMqttPahoClientFactory();
        factory.setServerURIs(this.mqttProperties.getUrl());
        factory.setUserName(this.mqttProperties.getUsername());
        factory.setPassword(this.mqttProperties.getPassword());
        factory.setCleanSession(Boolean.valueOf(this.mqttProperties.isCleanSession()));
        factory.setConnectionTimeout(Integer.valueOf(this.mqttProperties.getConnectionTimeout()));
        factory.setKeepAliveInterval(Integer.valueOf(this.mqttProperties.getKeepAliveInterval()));
        if (ObjectUtils.nullSafeEquals((Object)this.mqttProperties.getPersistence(), (Object)"file")) {
            factory.setPersistence((MqttClientPersistence)new MqttDefaultFilePersistence(this.mqttProperties.getPersistenceDirectory()));
        } else if (ObjectUtils.nullSafeEquals((Object)this.mqttProperties.getPersistence(), (Object)"memory")) {
            factory.setPersistence((MqttClientPersistence)new MemoryPersistence());
        }
        return factory;
    }
}

