/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.app.trigger;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.NoneNestedConditions;
import org.springframework.cloud.stream.app.trigger.DateTrigger;
import org.springframework.cloud.stream.app.trigger.TriggerProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.integration.scheduling.PollerMetadata;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.support.CronTrigger;
import org.springframework.scheduling.support.PeriodicTrigger;

@Configuration
public class TriggerConfiguration {
    private static final Log logger = LogFactory.getLog(TriggerConfiguration.class);
    @Autowired
    TriggerProperties triggerProperties;

    @Bean(name={"defaultPoller", "org.springframework.integration.context.defaultPollerMetadata"})
    public PollerMetadata defaultPoller(Trigger trigger) {
        logger.info((Object)("Trigger type: " + trigger));
        PollerMetadata pollerMetadata = new PollerMetadata();
        pollerMetadata.setTrigger(trigger);
        pollerMetadata.setMaxMessagesPerPoll(this.triggerProperties.getMaxMessages() > -1L ? this.triggerProperties.getMaxMessages() : 1L);
        return pollerMetadata;
    }

    @Bean(name={"POLLER_TRIGGER"})
    @ConditionalOnProperty(value={"trigger.cron"})
    public Trigger cronTrigger() {
        return new CronTrigger(this.triggerProperties.getCron());
    }

    @Bean(name={"POLLER_TRIGGER"})
    @Conditional(value={PeriodicTriggerCondition.class})
    public Trigger periodicTrigger() {
        PeriodicTrigger trigger = new PeriodicTrigger((long)this.triggerProperties.getFixedDelay(), this.triggerProperties.getTimeUnit());
        trigger.setInitialDelay((long)this.triggerProperties.getInitialDelay());
        return trigger;
    }

    @Bean(name={"POLLER_TRIGGER"})
    @ConditionalOnProperty(value={"trigger.date"})
    public Trigger dateTrigger() {
        return new DateTrigger(this.triggerProperties.getDate());
    }

    static class PeriodicTriggerCondition
    extends NoneNestedConditions {
        PeriodicTriggerCondition() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnProperty(value={"trigger.date"})
        static class dateTrigger {
            dateTrigger() {
            }
        }

        @ConditionalOnProperty(value={"trigger.cron"})
        static class cronTrigger {
            cronTrigger() {
            }
        }
    }
}

