/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.app.time;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.text.SimpleDateFormat;
import javax.validation.Constraint;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.Payload;

@Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.ANNOTATION_TYPE, ElementType.CONSTRUCTOR, ElementType.PARAMETER})
@Retention(value=RetentionPolicy.RUNTIME)
@Documented
@Constraint(validatedBy={DateFormatValidator.class})
public @interface DateFormat {
    public static final String DEFAULT_MESSAGE = "";

    public String message() default "";

    public Class<?>[] groups() default {};

    public Class<? extends Payload>[] payload() default {};

    public static class DateFormatValidator
    implements ConstraintValidator<DateFormat, CharSequence> {
        private String message;

        public void initialize(DateFormat constraintAnnotation) {
            this.message = constraintAnnotation.message();
        }

        public boolean isValid(CharSequence value, ConstraintValidatorContext context) {
            if (value == null) {
                return true;
            }
            try {
                new SimpleDateFormat(value.toString());
            }
            catch (IllegalArgumentException e) {
                if (DateFormat.DEFAULT_MESSAGE.equals(this.message)) {
                    context.disableDefaultConstraintViolation();
                    context.buildConstraintViolationWithTemplate(e.getMessage()).addConstraintViolation();
                }
                return false;
            }
            return true;
        }
    }

    @Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.ANNOTATION_TYPE, ElementType.CONSTRUCTOR, ElementType.PARAMETER})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Documented
    public static @interface List {
        public DateFormat[] value();
    }
}

