/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.app.tcp;

import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.cloud.stream.app.tcp.AbstractTcpConnectionFactoryProperties;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.integration.ip.tcp.serializer.AbstractByteArraySerializer;
import org.springframework.integration.ip.tcp.serializer.ByteArrayCrLfSerializer;
import org.springframework.integration.ip.tcp.serializer.ByteArrayLengthHeaderSerializer;
import org.springframework.integration.ip.tcp.serializer.ByteArrayLfSerializer;
import org.springframework.integration.ip.tcp.serializer.ByteArrayRawSerializer;
import org.springframework.integration.ip.tcp.serializer.ByteArraySingleTerminatorSerializer;
import org.springframework.integration.ip.tcp.serializer.ByteArrayStxEtxSerializer;
import org.springframework.util.Assert;

public class EncoderDecoderFactoryBean
extends AbstractFactoryBean<AbstractByteArraySerializer>
implements ApplicationEventPublisherAware {
    private final AbstractTcpConnectionFactoryProperties.Encoding encoding;
    private ApplicationEventPublisher applicationEventPublisher;
    private Integer maxMessageSize;

    public EncoderDecoderFactoryBean(AbstractTcpConnectionFactoryProperties.Encoding encoding) {
        Assert.notNull((Object)((Object)encoding), (String)"'encoding' cannot be null");
        this.encoding = encoding;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    public void setMaxMessageSize(int maxMessageSize) {
        this.maxMessageSize = maxMessageSize;
    }

    protected AbstractByteArraySerializer createInstance() throws Exception {
        ByteArrayCrLfSerializer codec;
        switch (this.encoding) {
            case CRLF: {
                codec = new ByteArrayCrLfSerializer();
                break;
            }
            case LF: {
                codec = new ByteArrayLfSerializer();
                break;
            }
            case NULL: {
                codec = new ByteArraySingleTerminatorSerializer(0);
                break;
            }
            case STXETX: {
                codec = new ByteArrayStxEtxSerializer();
                break;
            }
            case L1: {
                codec = new ByteArrayLengthHeaderSerializer(1);
                break;
            }
            case L2: {
                codec = new ByteArrayLengthHeaderSerializer(2);
                break;
            }
            case L4: {
                codec = new ByteArrayLengthHeaderSerializer(4);
                break;
            }
            case RAW: {
                codec = new ByteArrayRawSerializer();
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid encoding: " + (Object)((Object)this.encoding));
            }
        }
        codec.setApplicationEventPublisher(this.applicationEventPublisher);
        if (this.maxMessageSize != null) {
            codec.setMaxMessageSize(this.maxMessageSize.intValue());
        }
        return codec;
    }

    public Class<?> getObjectType() {
        return AbstractByteArraySerializer.class;
    }
}

