/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.app.ftp;

import org.apache.commons.net.ftp.FTPFile;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.stream.app.ftp.FtpSessionFactoryProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.integration.file.remote.session.CachingSessionFactory;
import org.springframework.integration.file.remote.session.SessionFactory;
import org.springframework.integration.ftp.session.DefaultFtpSessionFactory;

@Configuration
@EnableConfigurationProperties(value={FtpSessionFactoryProperties.class})
public class FtpSessionFactoryConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public SessionFactory<FTPFile> ftpSessionFactory(FtpSessionFactoryProperties properties) {
        DefaultFtpSessionFactory ftpSessionFactory = new DefaultFtpSessionFactory();
        ftpSessionFactory.setHost(properties.getHost());
        ftpSessionFactory.setPort(properties.getPort());
        ftpSessionFactory.setUsername(properties.getUsername());
        ftpSessionFactory.setPassword(properties.getPassword());
        ftpSessionFactory.setClientMode(properties.getClientMode().getMode());
        if (properties.getCacheSessions() != null) {
            CachingSessionFactory csf = new CachingSessionFactory((SessionFactory)ftpSessionFactory);
            return csf;
        }
        return ftpSessionFactory;
    }
}

