/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.zookeeper.discovery.configclient;

import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.x.discovery.ServiceDiscovery;
import org.apache.curator.x.discovery.ServiceDiscoveryBuilder;
import org.apache.curator.x.discovery.details.InstanceSerializer;
import org.apache.curator.x.discovery.details.JsonInstanceSerializer;
import org.springframework.boot.BootstrapContext;
import org.springframework.boot.BootstrapRegistry;
import org.springframework.boot.BootstrapRegistryInitializer;
import org.springframework.boot.context.properties.bind.BindHandler;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.cloud.commons.util.InetUtils;
import org.springframework.cloud.commons.util.InetUtilsProperties;
import org.springframework.cloud.config.client.ConfigServerInstanceProvider;
import org.springframework.cloud.zookeeper.CuratorFactory;
import org.springframework.cloud.zookeeper.discovery.ZookeeperDiscoveryClient;
import org.springframework.cloud.zookeeper.discovery.ZookeeperDiscoveryProperties;
import org.springframework.cloud.zookeeper.discovery.ZookeeperInstance;
import org.springframework.cloud.zookeeper.discovery.dependency.ZookeeperDependencies;
import org.springframework.cloud.zookeeper.support.DefaultServiceDiscoveryCustomizer;
import org.springframework.cloud.zookeeper.support.ServiceDiscoveryCustomizer;
import org.springframework.util.ClassUtils;

public class ZookeeperConfigServerBootstrapper
implements BootstrapRegistryInitializer {
    public void initialize(BootstrapRegistry registry) {
        if (!ClassUtils.isPresent((String)"org.springframework.cloud.config.client.ConfigServerInstanceProvider", null) || ClassUtils.isPresent((String)"org.springframework.cloud.bootstrap.marker.Marker", null)) {
            return;
        }
        CuratorFactory.registerCurator((BootstrapRegistry)registry, null, (boolean)true, bootstrapContext -> this.isEnabled((Binder)bootstrapContext.get(Binder.class)));
        registry.registerIfAbsent(ZookeeperDiscoveryProperties.class, context -> {
            Binder binder = (Binder)context.get(Binder.class);
            if (!this.isEnabled(binder)) {
                return null;
            }
            return (ZookeeperDiscoveryProperties)binder.bind("spring.cloud.zookeeper.discovery", Bindable.of(ZookeeperDiscoveryProperties.class), this.getBindHandler(context)).orElseGet(() -> new ZookeeperDiscoveryProperties(new InetUtils(new InetUtilsProperties())));
        });
        registry.registerIfAbsent(InstanceSerializer.class, context -> {
            if (!this.isEnabled((Binder)context.get(Binder.class))) {
                return null;
            }
            return new JsonInstanceSerializer(ZookeeperInstance.class);
        });
        registry.registerIfAbsent(ServiceDiscoveryCustomizer.class, context -> {
            if (!this.isEnabled((Binder)context.get(Binder.class))) {
                return null;
            }
            CuratorFramework curator = (CuratorFramework)context.get(CuratorFramework.class);
            ZookeeperDiscoveryProperties properties = (ZookeeperDiscoveryProperties)context.get(ZookeeperDiscoveryProperties.class);
            InstanceSerializer serializer = (InstanceSerializer)context.get(InstanceSerializer.class);
            return new DefaultServiceDiscoveryCustomizer(curator, properties, (InstanceSerializer<ZookeeperInstance>)serializer);
        });
        registry.registerIfAbsent(ServiceDiscovery.class, context -> {
            if (!this.isEnabled((Binder)context.get(Binder.class))) {
                return null;
            }
            ServiceDiscoveryCustomizer customizer = (ServiceDiscoveryCustomizer)context.get(ServiceDiscoveryCustomizer.class);
            return customizer.customize((ServiceDiscoveryBuilder<ZookeeperInstance>)ServiceDiscoveryBuilder.builder(ZookeeperInstance.class));
        });
        registry.registerIfAbsent(ZookeeperDiscoveryClient.class, context -> {
            Binder binder = (Binder)context.get(Binder.class);
            if (!this.isEnabled(binder)) {
                return null;
            }
            ServiceDiscovery serviceDiscovery = (ServiceDiscovery)context.get(ServiceDiscovery.class);
            ZookeeperDependencies dependencies = (ZookeeperDependencies)binder.bind("spring.cloud.zookeeper", Bindable.of(ZookeeperDependencies.class), this.getBindHandler(context)).orElseGet(ZookeeperDependencies::new);
            ZookeeperDiscoveryProperties discoveryProperties = (ZookeeperDiscoveryProperties)context.get(ZookeeperDiscoveryProperties.class);
            return new ZookeeperDiscoveryClient((ServiceDiscovery<ZookeeperInstance>)serviceDiscovery, dependencies, discoveryProperties);
        });
        registry.registerIfAbsent(ConfigServerInstanceProvider.Function.class, context -> {
            if (!this.isEnabled((Binder)context.get(Binder.class))) {
                return null;
            }
            return ((ZookeeperDiscoveryClient)context.get(ZookeeperDiscoveryClient.class))::getInstances;
        });
        registry.addCloseListener(event -> {
            ZookeeperDiscoveryClient discoveryClient = (ZookeeperDiscoveryClient)event.getBootstrapContext().get(ZookeeperDiscoveryClient.class);
            if (discoveryClient != null) {
                event.getApplicationContext().getBeanFactory().registerSingleton("zookeeperServiceDiscovery", (Object)discoveryClient);
            }
        });
    }

    private BindHandler getBindHandler(BootstrapContext context) {
        return (BindHandler)context.getOrElse(BindHandler.class, null);
    }

    private boolean isEnabled(Binder binder) {
        return (Boolean)binder.bind("spring.cloud.config.discovery.enabled", Boolean.class).orElse((Object)false);
    }
}

