/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.zookeeper.discovery.dependency;

import feign.Client;
import feign.Request;
import feign.RequestTemplate;
import feign.Response;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.client.loadbalancer.LoadBalancerClient;
import org.springframework.cloud.client.loadbalancer.reactive.LoadBalancerProperties;
import org.springframework.cloud.loadbalancer.blocking.client.BlockingLoadBalancerClient;
import org.springframework.cloud.loadbalancer.config.BlockingLoadBalancerClientAutoConfiguration;
import org.springframework.cloud.openfeign.loadbalancer.FeignBlockingLoadBalancerClient;
import org.springframework.cloud.openfeign.loadbalancer.FeignLoadBalancerAutoConfiguration;
import org.springframework.cloud.zookeeper.ConditionalOnZookeeperEnabled;
import org.springframework.cloud.zookeeper.discovery.dependency.ConditionalOnDependenciesPassed;
import org.springframework.cloud.zookeeper.discovery.dependency.ZookeeperDependencies;
import org.springframework.cloud.zookeeper.discovery.dependency.ZookeeperDependency;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Configuration(proxyBeanMethods=false)
@ConditionalOnDependenciesPassed
@ConditionalOnZookeeperEnabled
@ConditionalOnProperty(value={"spring.cloud.zookeeper.dependency.headers.enabled"}, matchIfMissing=true)
@ConditionalOnClass(value={Client.class, FeignBlockingLoadBalancerClient.class})
@ConditionalOnBean(value={BlockingLoadBalancerClient.class})
@AutoConfigureAfter(value={FeignLoadBalancerAutoConfiguration.class, BlockingLoadBalancerClientAutoConfiguration.class})
public class DependencyFeignClientAutoConfiguration {
    private final FeignBlockingLoadBalancerClient feignLoadBalancerClient;
    private final ZookeeperDependencies zookeeperDependencies;
    private final BlockingLoadBalancerClient loadBalancerClient;
    private final LoadBalancerProperties loadBalancerProperties;

    public DependencyFeignClientAutoConfiguration(@Autowired(required=false) FeignBlockingLoadBalancerClient feignLoadBalancerClient, ZookeeperDependencies zookeeperDependencies, BlockingLoadBalancerClient loadBalancerClient, LoadBalancerProperties loadBalancerProperties) {
        this.feignLoadBalancerClient = feignLoadBalancerClient;
        this.zookeeperDependencies = zookeeperDependencies;
        this.loadBalancerClient = loadBalancerClient;
        this.loadBalancerProperties = loadBalancerProperties;
    }

    @Bean
    @Primary
    Client dependencyBasedFeignClient() {
        return new FeignBlockingLoadBalancerClient((Client)new Client.Default(null, null), (LoadBalancerClient)this.loadBalancerClient, this.loadBalancerProperties){

            public Response execute(Request request, Request.Options options) throws IOException {
                URI asUri = URI.create(request.url());
                String clientName = asUri.getHost();
                ZookeeperDependency dependencyForAlias = DependencyFeignClientAutoConfiguration.this.zookeeperDependencies.getDependencyForAlias(clientName);
                Map<String, Collection<String>> headers = this.getUpdatedHeadersIfPossible(request, dependencyForAlias);
                if (DependencyFeignClientAutoConfiguration.this.feignLoadBalancerClient != null) {
                    return DependencyFeignClientAutoConfiguration.this.feignLoadBalancerClient.execute(this.request(request, headers), options);
                }
                return super.execute(this.request(request, headers), options);
            }

            private Request request(Request request, Map<String, Collection<String>> headers) {
                return Request.create((Request.HttpMethod)request.httpMethod(), (String)request.url(), headers, (byte[])request.body(), (Charset)request.charset(), (RequestTemplate)request.requestTemplate());
            }

            private Map<String, Collection<String>> getUpdatedHeadersIfPossible(Request request, ZookeeperDependency dependencyForAlias) {
                if (dependencyForAlias != null) {
                    return Collections.unmodifiableMap(new HashMap<String, Collection<String>>(dependencyForAlias.getUpdatedHeaders(request.headers())));
                }
                return request.headers();
            }
        };
    }
}

