/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.zookeeper.discovery;

import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.x.discovery.ServiceDiscovery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.autoconfigure.health.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.client.CommonsClientAutoConfiguration;
import org.springframework.cloud.client.ConditionalOnDiscoveryEnabled;
import org.springframework.cloud.client.discovery.noop.NoopDiscoveryClientAutoConfiguration;
import org.springframework.cloud.commons.util.InetUtils;
import org.springframework.cloud.zookeeper.discovery.ConditionalOnZookeeperDiscoveryEnabled;
import org.springframework.cloud.zookeeper.discovery.ZookeeperDiscoveryHealthIndicator;
import org.springframework.cloud.zookeeper.discovery.ZookeeperDiscoveryProperties;
import org.springframework.cloud.zookeeper.discovery.ZookeeperInstance;
import org.springframework.cloud.zookeeper.discovery.ZookeeperServiceWatch;
import org.springframework.cloud.zookeeper.discovery.dependency.ZookeeperDependencies;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnDiscoveryEnabled
@ConditionalOnZookeeperDiscoveryEnabled
@AutoConfigureBefore(value={CommonsClientAutoConfiguration.class, NoopDiscoveryClientAutoConfiguration.class})
public class ZookeeperDiscoveryAutoConfiguration {
    @Autowired
    private CuratorFramework curator;

    @Bean
    @ConditionalOnMissingBean
    public ZookeeperDiscoveryProperties zookeeperDiscoveryProperties(InetUtils inetUtils) {
        return new ZookeeperDiscoveryProperties(inetUtils);
    }

    @Bean
    public ZookeeperServiceWatch zookeeperServiceWatch(ZookeeperDiscoveryProperties zookeeperDiscoveryProperties) {
        return new ZookeeperServiceWatch(this.curator, zookeeperDiscoveryProperties);
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={Endpoint.class, HealthIndicator.class})
    protected static class ZookeeperDiscoveryHealthConfig {
        @Autowired(required=false)
        private ZookeeperDependencies zookeeperDependencies;

        protected ZookeeperDiscoveryHealthConfig() {
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnEnabledHealthIndicator(value="zookeeper")
        public ZookeeperDiscoveryHealthIndicator zookeeperDiscoveryHealthIndicator(CuratorFramework curatorFramework, ServiceDiscovery<ZookeeperInstance> serviceDiscovery, ZookeeperDiscoveryProperties properties) {
            return new ZookeeperDiscoveryHealthIndicator(curatorFramework, serviceDiscovery, this.zookeeperDependencies, properties);
        }
    }
}

