/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.zookeeper.discovery.dependency;

import java.util.Collections;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.bind.RelaxedPropertyResolver;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.env.PropertySource;
import org.springframework.util.StringUtils;

public class DependencyEnvironmentPostProcessor
implements EnvironmentPostProcessor,
Ordered {
    private int order = -2147483637;

    public int getOrder() {
        return this.order;
    }

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        String prefix;
        RelaxedPropertyResolver resolver = new RelaxedPropertyResolver((PropertyResolver)environment);
        String appName = resolver.getProperty("spring.application.name");
        if (StringUtils.hasText((String)appName) && !appName.contains("/") && StringUtils.hasText((String)(prefix = resolver.getProperty("spring.cloud.zookeeper.prefix")))) {
            StringBuilder prefixedName = new StringBuilder();
            if (!prefix.startsWith("/")) {
                prefixedName.append("/");
            }
            prefixedName.append(prefix);
            if (!prefix.endsWith("/")) {
                prefixedName.append("/");
            }
            prefixedName.append(appName);
            MapPropertySource propertySource = new MapPropertySource("zookeeperDependencyEnvironment", Collections.singletonMap("spring.application.name", prefixedName.toString()));
            environment.getPropertySources().addFirst((PropertySource)propertySource);
        }
    }
}

